# -*- coding: utf-8 -*-

import pygame
import time
from Sol import Chemin, Mur, Herbe, Eau, Vide
from Joueur import Joueur

pygame.init()

image_vide = pygame.image.load('images/image_vide.png')

plouf0 = pygame.image.load('images/plouf0.png')
plouf0 = pygame.transform.scale(plouf0, (50,50))
plouf1 = pygame.image.load('images/plouf1.png')
plouf1 = pygame.transform.scale(plouf1, (50,50))

chemin = pygame.image.load('images/chemin.png')
chemin2 = pygame.transform.scale(chemin, (15*50,9*50))
chemin = pygame.transform.scale(chemin, (50,50))

mur = pygame.image.load('images/mur.png')
mur = pygame.transform.scale(mur, (50,50))

herbe = pygame.image.load('images/herbe.png')
herbe = pygame.transform.scale(herbe, (50,50))
eau = pygame.image.load('images/eau.png')
eau = pygame.transform.scale(eau, (50,50))

eau_n = pygame.image.load('images/eau_n.png')
eau_n = pygame.transform.scale(eau_n, (50,50))
eau_s = pygame.image.load('images/eau_s.png')
eau_s = pygame.transform.scale(eau_s, (50,50))
eau_e = pygame.image.load('images/eau_e.png')
eau_e = pygame.transform.scale(eau_e, (50,50))
eau_o = pygame.image.load('images/eau_o.png')
eau_o = pygame.transform.scale(eau_o, (50,50))

eau_ne = pygame.image.load('images/eau_ne.png')
eau_ne = pygame.transform.scale(eau_ne, (50,50))
eau_no = pygame.image.load('images/eau_no.png')
eau_no = pygame.transform.scale(eau_no, (50,50))
eau_se = pygame.image.load('images/eau_se.png')
eau_se = pygame.transform.scale(eau_se, (50,50))
eau_so = pygame.image.load('images/eau_so.png')
eau_so = pygame.transform.scale(eau_so, (50,50))

eau_coin_ne = pygame.image.load('images/eau_coin_ne.png')
eau_coin_ne = pygame.transform.scale(eau_coin_ne, (50,50))
eau_coin_no = pygame.image.load('images/eau_coin_no.png')
eau_coin_no = pygame.transform.scale(eau_coin_no, (50,50))
eau_coin_se = pygame.image.load('images/eau_coin_se.png')
eau_coin_se = pygame.transform.scale(eau_coin_se, (50,50))
eau_coin_so = pygame.image.load('images/eau_coin_so.png')
eau_coin_so = pygame.transform.scale(eau_coin_so, (50,50))

eau_diago_neso = pygame.image.load('images/eau_diago_neso.png')
eau_diago_neso = pygame.transform.scale(eau_diago_neso, (50,50))
eau_diago_nose = pygame.image.load('images/eau_diago_nose.png')
eau_diago_nose = pygame.transform.scale(eau_diago_nose, (50,50))

joueur_face = pygame.image.load('images/aventurier_face.png')
joueur_face = pygame.transform.scale(joueur_face, (60,60))
joueur_face_1 = pygame.image.load('images/aventurier_face_1.png')
joueur_face_1 = pygame.transform.scale(joueur_face_1, (60,60))
joueur_face_2 = pygame.image.load('images/aventurier_face_2.png')
joueur_face_2 = pygame.transform.scale(joueur_face_2, (60,60))

joueur_dos = pygame.image.load('images/aventurier_dos.png')
joueur_dos = pygame.transform.scale(joueur_dos, (60,60))
joueur_dos_1 = pygame.image.load('images/aventurier_dos_1.png')
joueur_dos_1 = pygame.transform.scale(joueur_dos_1, (60,60))
joueur_dos_2 = pygame.image.load('images/aventurier_dos_2.png')
joueur_dos_2 = pygame.transform.scale(joueur_dos_2, (60,60))

joueur_profil_droit = pygame.image.load('images/aventurier_profil_droit.png')
joueur_profil_droit = pygame.transform.scale(joueur_profil_droit, (60,60))
joueur_profil_droit_1 = pygame.image.load('images/aventurier_profil_droit_1.png')
joueur_profil_droit_1 = pygame.transform.scale(joueur_profil_droit_1, (60,60))
joueur_profil_droit_2 = pygame.image.load('images/aventurier_profil_droit_2.png')
joueur_profil_droit_2 = pygame.transform.scale(joueur_profil_droit_2, (60,60))

joueur_profil_gauche = pygame.image.load('images/aventurier_profil_gauche.png')
joueur_profil_gauche = pygame.transform.scale(joueur_profil_gauche, (60,60))
joueur_profil_gauche_1 = pygame.image.load('images/aventurier_profil_gauche_1.png')
joueur_profil_gauche_1 = pygame.transform.scale(joueur_profil_gauche_1, (60,60))
joueur_profil_gauche_2 = pygame.image.load('images/aventurier_profil_gauche_2.png')
joueur_profil_gauche_2 = pygame.transform.scale(joueur_profil_gauche_2, (60,60))



farfadet = pygame.image.load('images/farfadet.png')
farfadet = pygame.transform.scale(farfadet, (150,110))

farfadet_2 = pygame.image.load('images/farfadet_2.png')
farfadet_2 = pygame.transform.scale(farfadet_2, (150,110))
farfadet_2_endormi = pygame.image.load('images/farfadet_2_endormi.png')
farfadet_2_endormi = pygame.transform.scale(farfadet_2_endormi, (150,110))

farfadet_3 = pygame.image.load('images/farfadet_3.png')
farfadet_3 = pygame.transform.scale(farfadet_3, (150,110))
farfadet_3_endormi = pygame.image.load('images/farfadet_3_endormi.png')
farfadet_3_endormi = pygame.transform.scale(farfadet_3_endormi, (150,110))

farfadet_4 = pygame.image.load('images/farfadet_4.png')
farfadet_4 = pygame.transform.scale(farfadet_4, (150,110))
farfadet_4_endormi = pygame.image.load('images/farfadet_4_endormi.png')
farfadet_4_endormi = pygame.transform.scale(farfadet_4_endormi, (150,110))

farfadet_chef = pygame.image.load('images/farfadet_chef_combat_0.png')
farfadet_chef = pygame.transform.scale(farfadet_chef, (150,110))
farfadet_chef_endormi = pygame.image.load('images/farfadet_chef_combat_2.png')
farfadet_chef_endormi = pygame.transform.scale(farfadet_chef_endormi, (150,110))

farfadet_serviteur = pygame.image.load('images/farfadet_serviteur.png')
farfadet_serviteur = pygame.transform.scale(farfadet_serviteur, (150,110))
farfadet_serviteur_endormi = pygame.image.load('images/farfadet_serviteur_endormi.png')
farfadet_serviteur_endormi = pygame.transform.scale(farfadet_serviteur_endormi, (150,110))

farfadet_5 = pygame.image.load('images/farfadet_5.png')
farfadet_5 = pygame.transform.scale(farfadet_5, (150,110))
farfadet_5_endormi = pygame.image.load('images/farfadet_5_endormi.png')
farfadet_5_endormi = pygame.transform.scale(farfadet_5_endormi, (150,110))

farfadet_6 = pygame.image.load('images/farfadet_6.png')
farfadet_6 = pygame.transform.scale(farfadet_6, (150,110))
farfadet_6_endormi = pygame.image.load('images/farfadet_6_endormi.png')
farfadet_6_endormi = pygame.transform.scale(farfadet_6_endormi, (150,110))

farfadet_7 = pygame.image.load('images/farfadet_7.png')
farfadet_7 = pygame.transform.scale(farfadet_7, (150,110))
farfadet_7_endormi = pygame.image.load('images/farfadet_7_endormi.png')
farfadet_7_endormi = pygame.transform.scale(farfadet_7_endormi, (150,110))

farfadet_8 = pygame.image.load('images/farfadet_8.png')
farfadet_8 = pygame.transform.scale(farfadet_8, (150,110))
farfadet_8_endormi = pygame.image.load('images/farfadet_8_endormi.png')
farfadet_8_endormi = pygame.transform.scale(farfadet_8_endormi, (150,110))

lutin_1 = pygame.image.load('images/lutin_1.png')
lutin_1 = pygame.transform.scale(lutin_1, (150,110))

lutin_2 = pygame.image.load('images/lutin_2.png')
lutin_2 = pygame.transform.scale(lutin_2, (150,110))

viel_homme_attaque = pygame.image.load('images/viel_homme_attaque.png')
viel_homme_attaque = pygame.transform.scale(viel_homme_attaque, (150,110))
viel_homme_pleure = pygame.image.load('images/viel_homme_pleure.png')
viel_homme_pleure = pygame.transform.scale(viel_homme_pleure, (150,110))
viel_homme_dit_au_revoir = pygame.image.load('images/viel_homme_dit_au_revoir.png')
viel_homme_dit_au_revoir = pygame.transform.scale(viel_homme_dit_au_revoir, (150,110))
viel_homme_parle_0 = pygame.image.load('images/viel_homme_parle_0.png')
viel_homme_parle_0 = pygame.transform.scale(viel_homme_parle_0, (150,110))
viel_homme_parle_1 = pygame.image.load('images/viel_homme_parle_1.png')
viel_homme_parle_1 = pygame.transform.scale(viel_homme_parle_1, (150,110))
viel_homme_parle_2 = pygame.image.load('images/viel_homme_parle_2.png')
viel_homme_parle_2 = pygame.transform.scale(viel_homme_parle_2, (150,110))
viel_homme_parle_3 = pygame.image.load('images/viel_homme_parle_3.png')
viel_homme_parle_3 = pygame.transform.scale(viel_homme_parle_3, (150,110))
viel_homme_parle_4 = pygame.image.load('images/viel_homme_parle_4.png')
viel_homme_parle_4 = pygame.transform.scale(viel_homme_parle_4, (150,110))

nain = pygame.image.load('images/nain.png')
nain = pygame.transform.scale(nain, (150,110))

coffre = pygame.image.load('images/coffre_en_bois.png')
coffre_en_bois = pygame.transform.scale(coffre, (50,50))
boite_en_bois = pygame.transform.scale(coffre, (25,25))
coffre_ouvert = pygame.image.load('images/coffre_en_bois_ouvert.png')
coffre_en_bois_ouvert = pygame.transform.scale(coffre_ouvert, (50,50))
boite_en_bois_ouvert = pygame.transform.scale(coffre_ouvert, (25,25))

coffre_en_fer = pygame.image.load('images/coffre_en_fer.png')
coffre_en_fer = pygame.transform.scale(coffre_en_fer, (50,50))
coffre_en_fer_ouvert = pygame.image.load('images/coffre_en_fer_ouvert.png')
coffre_en_fer_ouvert = pygame.transform.scale(coffre_en_fer_ouvert, (50,50))

coffre_en_or = pygame.image.load('images/coffre_en_or.png')
coffre_en_or = pygame.transform.scale(coffre_en_or, (50,50))
coffre_en_or_ouvert = pygame.image.load('images/coffre_en_or_ouvert.png')
coffre_en_or_ouvert = pygame.transform.scale(coffre_en_or_ouvert, (50,50))

commode = pygame.image.load('images/commode.png')
commode = pygame.transform.scale(commode, (100,100))



table = pygame.image.load('images/table.png')
table = pygame.transform.scale(table,(50,50))

pot = pygame.image.load('images/pot.png')
pot = pygame.transform.scale(pot, (50,50))
pot_couvert = pygame.image.load('images/pot_couvert.png')
pot_couvert = pygame.transform.scale(pot_couvert, (50,50))
tonneau = pygame.image.load('images/tonneau.png')
tonneau = pygame.transform.scale(tonneau, (50,50))

marmitte = pygame.image.load('images/marmitte.png')
marmitte = pygame.transform.scale(marmitte, (50,50))
evier = pygame.image.load('images/evier.png')
evier = pygame.transform.scale(evier, (50,50))

assiette_pleine = pygame.image.load('images/assiette_pleine.png')
assiette_pleine = pygame.transform.scale(assiette_pleine, (50,50))
assiette_vide = pygame.image.load('images/assiette_vide.png')
assiette_vide = pygame.transform.scale(assiette_vide, (50,50))

rangement_epees = pygame.image.load('images/rangement_epees.png')
rangement_epees = pygame.transform.scale(rangement_epees, (100,100))
rangement_lances = pygame.image.load('images/rangement_lances.png')
rangement_lances = pygame.transform.scale(rangement_lances, (100,100))
rangement_arc = pygame.image.load('images/rangement_arc.png')
rangement_arc = pygame.transform.scale(rangement_arc, (100,100))
sabre_au_mur = pygame.image.load('images/sabre_au_mur.png')
sabre_au_mur = pygame.transform.scale(sabre_au_mur, (60,60))



game_over = pygame.image.load('images/game_over.png')





class Carte:
    def __init__(self, game, carte_n = None, carte_s = None, carte_e = None, carte_o = None, 
                 largeur = 16, hauteur = 10, marge_x = 340, marge_y = 90):
        self.game = game
        self.carte_n = carte_n
        self.carte_s = carte_s
        self.carte_e = carte_e
        self.carte_o = carte_o
        self.joueur = Joueur(self)
        self.__largeur = largeur
        self.__hauteur = hauteur
        self.__marge_x = marge_x
        self.__marge_y = marge_y
        self.__grille = [[None for i in range(self.__largeur)] for i in range(self.__hauteur)]
        self.__portes_ns = {}
        self.__portes_eo = {}
        self.__monstres = []
        self.__personnages = []
        self.__coffres = []
        self.__objets = []
        
        self.__images = {'chemin2':chemin2,'chemin' : chemin, 'mur' : mur, 'herbe' : herbe, 'eau' : eau,
                         'eau_n' : eau_n, 'eau_s' : eau_s, 'eau_e' : eau_e, 'eau_o' : eau_o, 
                         'eau_ne' : eau_ne, 'eau_no' : eau_no, 'eau_se' : eau_se, 'eau_so' : eau_so, 
                         'eau_coin_ne' : eau_coin_ne, 'eau_coin_no' : eau_coin_no, 
                         'eau_coin_se' : eau_coin_se, 'eau_coin_so' : eau_coin_so, 
                         'eau_diago_neso' : eau_diago_neso, 'eau_diago_nose' : eau_diago_nose,
                         'plouf0':plouf0, 'plouf1':plouf1, 
                         
                         
                         'joueur_face' : joueur_face, 'joueur_face_1' : joueur_face_1, 'joueur_face_2' : joueur_face_2, 
                         'joueur_dos':joueur_dos, 'joueur_dos_1':joueur_dos_1, 'joueur_dos_2':joueur_dos_2,
                         'joueur_profil_droit':joueur_profil_droit, 'joueur_profil_droit_1':joueur_profil_droit_1, 'joueur_profil_droit_2':joueur_profil_droit_2,
                         'joueur_profil_gauche':joueur_profil_gauche, 'joueur_profil_gauche_1':joueur_profil_gauche_1, 'joueur_profil_gauche_2':joueur_profil_gauche_2,
                         
                         
                         
                         'farfadet':farfadet,
                         'farfadet_2':farfadet_2, 'farfadet_2_endormi':farfadet_2_endormi,
                         'serpent':image_vide,
                         'farfadet_3':farfadet_3, 'farfadet_3_endormi':farfadet_3_endormi,
                         'farfadet_4':farfadet_4, 'farfadet_4_endormi':farfadet_4_endormi,
                         'farfadet_chef':farfadet_chef, 'farfadet_chef_endormi':farfadet_chef_endormi,
                         'farfadet_serviteur':farfadet_serviteur, 'farfadet_serviteur_endormi':farfadet_serviteur_endormi,
                         'farfadet_5':farfadet_5, 'farfadet_5_endormi':farfadet_5_endormi,
                         'farfadet_6':farfadet_6, 'farfadet_6_endormi':farfadet_6_endormi,
                         'farfadet_7':farfadet_7, 'farfadet_7_endormi':farfadet_7_endormi,
                         'farfadet_8':farfadet_8, 'farfadet_8_endormi':farfadet_8_endormi,
                         'lutin_1':lutin_1, 'lutin_2':lutin_2, 
                         
                         
                         'viel_homme_attaque':viel_homme_attaque, 'viel_homme_pleure':viel_homme_pleure, 
                         'viel_homme_dit_au_revoir':viel_homme_dit_au_revoir, 'viel_homme_parti':image_vide, 
                         'viel_homme_parle_0':viel_homme_parle_0, 'viel_homme_parle_1':viel_homme_parle_1, 
                         'viel_homme_parle_2':viel_homme_parle_2, 'viel_homme_parle_3':viel_homme_parle_3, 
                         'viel_homme_parle_4':viel_homme_parle_4, 
                         
                         'nain_mort':nain,
                         
                         
                         'coffre_en_bois':coffre_en_bois, 'coffre_en_bois_ouvert':coffre_en_bois_ouvert,
                         'boite_en_bois':boite_en_bois, 'boite_en_bois_ouvert':boite_en_bois_ouvert,
                         'coffre_en_fer':coffre_en_fer, 'coffre_en_fer_ouvert':coffre_en_fer_ouvert,
                         'coffre_en_or':coffre_en_or, 'coffre_en_or_ouvert':coffre_en_or_ouvert,
                         
                         'table':table, 'commode':commode, 'marmitte':marmitte,'evier':evier,
                         'pot':pot, 'pot_couvert':pot_couvert, 'tonneau':tonneau,
                         'assiette_pleine':assiette_pleine, 'assiette_vide':assiette_vide,
                         'rangement_epees':rangement_epees, 'rangement_lances':rangement_lances, 
                         'rangement_arc':rangement_arc, 'sabre_au_mur':sabre_au_mur,
                         
                         'game_over':pygame.transform.scale(game_over,(650,650*game_over.get_height()//game_over.get_width()))}
        self.__marge_image = {'viel_homme':(-50,-58),'nain':(-35,-45),
            
                              'boite_en_bois':(12,-4),'boite_en_bois_ouvert':(12,-4),
                              'coffre_en_fer':(0,-5),'coffre_en_fer_ouvert':(0,-5),
                              'coffre_en_or':(0,-5),'coffre_en_or_ouvert':(0,-5),
                              'coffre_en_bois':(0,-5),'coffre_en_bois_ouvert':(0,-5),
                              'table':(0,-10), 'commode':(-25,-50),
                              'marmitte':(0,-17),'evier':(0,-5),
                              'pot':(0,-8),'pot_couvert':(0,-8),'tonneau':(0,-8),
                              'assiette_pleine':(0,-17),'assiette_vide':(0,-17),
                              'rangement_epees':(-25,-60), 'rangement_lances':(-25,-60),
                              'rangement_arc':(-25,-60), 'rangement_vide':(-25,-60),
                              'sabre_au_mur':(-5,0)}
        
        self.__timer_joueur = time.time()
        self.__timer_personnages = time.time()
        
        self.__game_over = False
    
    
    
    def ajouter_carte_n(self,carte):
        self.carte_n = carte
    
    def ajouter_carte_s(self,carte):
        self.carte_s = carte
    
    def ajouter_carte_e(self,carte):
        self.carte_e = carte
    
    def ajouter_carte_o(self,carte):
        self.carte_o = carte
    
    def largeur(self):
        return self.__largeur
    
    def hauteur(self):
        return self.__hauteur
        
    def game_over(self):
        self.__game_over = True
    
    
    
    ###################    GETTER    ###################
    
    
    def get(self, pos):
        """renvoie le sol situé à la position pos"""
        x,y = pos
        if x<0 or y<0 or x>=self.largeur() or y>=self.hauteur():
            return None
        return self.__grille[y][x]
    
    def get_type(self, pos):
        """renvoie le type de sol situé à la position pos"""
        x,y = pos
        if x<0 or y<0 or x>=self.largeur() or y>=self.hauteur():
            return "dark territory"
        if self.__grille[y][x] is None:
            return None
        return self.__grille[y][x].__repr__()
    
    
    def get_porte(self,pos:tuple ,orientation:str):
        """"renvoie la porte située à la position pos"""
        x,y = pos
        if orientation == 'n':
            return self.__portes_ns.get((x,y))
        elif orientation == 's':
            return self.__portes_ns.get((x,y+1))
        elif orientation == 'o':
            return self.__portes_eo.get((x,y))
        else:
            return self.__portes_eo.get((x+1,y))
    
    def get_monstre(self,pos:tuple):
        """"renvoie le monstre situé à la position pos"""
        x,y=pos
        for monstre in self.__monstres:
            if monstre.get_pos_x()==x and monstre.get_pos_y()==y:
                return monstre
    
    def get_personnage(self,pos:tuple):
        """"renvoie le personnage situé à la position pos"""
        x,y=pos
        for personnage in self.__personnages:
            if personnage.get_pos_x()==x and personnage.get_pos_y()==y:
                return personnage
    
    def get_coffre(self,pos:tuple):
        """"renvoie lae coffre situé à la position pos"""
        x,y=pos
        for coffre in self.__coffres:
            if coffre.get_pos_x()==x and coffre.get_pos_y()==y:
                return coffre
    
    def get_objet(self,pos:tuple):
        """"renvoie l'objet situé à la position pos"""
        x,y=pos
        for objet in self.__objets:
            if objet.get_pos_x()==x and objet.get_pos_y()==y:
                return objet
    
    ###################    AJOUTER    ###################
    
    
    def ajouter(self, objet, pos,camoufle=False):
        """Ajoute sur la carte l'objet demandé ('chemin', 'mur', 'herbe', 'eau' ou 'vide') à la position pos (x,y)"""
        assert objet == 'chemin' or objet == 'mur' or objet == 'herbe' or objet == 'eau' or objet == 'vide', 'cet objet ne peut pas être ajouté sur la carte'
        assert type(pos) == tuple, 'pos doit être un tuple de deux éléments (x, y)'
        assert len(pos) == 2, 'pos doit être un tuple de deux éléments (x, y)'
        assert pos[0]>=0 and pos[1]>=0 and pos[0]<self.largeur() and pos[1]<self.hauteur(), 'position incorrecte'
        
        x , y = pos
        if objet == 'chemin':
            self.__grille[y][x] = Chemin(self,pos,camoufle)
        elif objet == 'mur':
            self.__grille[y][x] = Mur(self,pos)
        elif objet == 'herbe':
            self.__grille[y][x] = Herbe(self,pos)
        elif objet == 'eau':
            self.__grille[y][x] = Eau(self,pos)
        elif objet == 'vide':
            self.__grille[y][x] = Vide(self,pos)
            
            
    def ajouter_surface(self, objet, pos,camoufle=False):
        """Ajoute sur la carte l'objet demandé ('chemin', 'mur', 'herbe','eau' ou 'vide') sur toute la surface pos (x1, y1, x2, y2)"""
        assert objet == 'chemin' or objet == 'mur' or objet == 'herbe' or objet == 'eau' or objet == 'vide', 'cet objet ne peut pas être ajouté sur la carte'
        assert type(pos) == tuple, 'pos doit être un tuple de quatre éléments (x1, y1, x2, y2)'
        assert len(pos) == 4, 'pos doit être un tuple de quatre éléments (x1, y1, x2, y2)'
        
        x1, y1, x2, y2 = pos
        for x in range(x1, x2+1):
            for y in range(y1, y2+1):
                self.ajouter(objet,(x,y),camoufle)
    
    def ajouter_piece(self,piece):
        x1,y1,x2,y2 = piece.get_surface()
        for x in range(x1, x2+1):
            for y in range(y1, y2+1):
                if self.__grille[y][x] is not None:
                    self.__grille[y][x].ajouter_piece(piece)
                    
    def ajouter_monstre(self,monstre):
        self.__monstres.append(monstre)
        
    def ajouter_personnage(self,personnage):
        self.__personnages.append(personnage)
    
    def ajouter_porte(self,porte):
        x = porte.get_pos_x()
        y = porte.get_pos_y()
        orientation = porte.get_orientation()
        if orientation == 'n':
            self.__portes_ns[(x,y)]=porte
        elif orientation == 's':
            self.__portes_ns[(x,y+1)]=porte
        elif orientation == 'o':
            self.__portes_eo[(x,y)]=porte
        else:
            self.__portes_eo[(x+1,y)]=porte
        
    def ajouter_coffre(self,coffre):
        self.__coffres.append(coffre)
        
    def ajouter_objet(self,objet):
        self.__objets.append(objet)


    
    def parties_innondees(self,pos):
        """
        renvoie une liste qui contient les coins innondés d'une case dont la 
        position est donnée en argument.
        """
        assert self.get_type(pos) == 'Herbe()', "La position pos doit correspondre à un carré d'Herbe()."
        
        liste = []
        x1,y1 = pos
        for y in range(-1,2):
            for x in range(-1,2):
                if self.get_type((x1 + x, y1 + y)) == 'Eau()':
                    if x == 0:
                        ch = 'n s'[y+1] # y=0 est impossible car la pos x1,y1 correspond à un carré d'herbe
                        if not ch+'o' in liste:
                            liste.append(ch+'o')
                        if not ch+'e' in liste:
                            liste.append(ch+'e')
                    elif y == 0:
                        ch = 'o e'[x+1]
                        if not 'n'+ch in liste:
                            liste.append('n'+ch)
                        if not 's'+ch in liste:
                            liste.append('s'+ch)
                        
                    else:
                        ch_x = 'o e'[x+1] # x=0 est impossible (else)
                        ch_y = 'n s'[y+1]
                        if not ch_y+ch_x in liste:
                            liste.append(ch_y+ch_x)
                            
        return liste

    def cote_eau(self,liste):
       i=0
       while i<4:
           if not['ne','no','so','se'][i] in liste:                
              return ['ne','no','so','se'][i-2]
           i+=1
    
    def ajouter_bordure(self):
        for y in range(self.__hauteur):
            for x in range(self.__largeur):
                if self.get_type((x,y))=="Herbe()":
                    liste = self.parties_innondees((x,y))
                    
                    if len(liste)==4:
                        self.__grille[y][x].set_image('eau')
                    elif len(liste)==3:
                        self.__grille[y][x].set_image('eau_'+self.cote_eau(liste))
                    elif len(liste)==2:
                        if liste[0][0] == liste[1][0]: #'ne' et 'no' ou 'se' et 'so'
                            self.__grille[y][x].set_image('eau_'+liste[0][0])
                        elif liste[0][1] == liste[1][1]:
                            self.__grille[y][x].set_image('eau_'+liste[0][1])
                        else:
                            if liste[0][0]=='n': #le premier elt de la liste indique le coin nord
                                self.__grille[y][x].set_image('eau_diago_'+liste[0]+liste[1]) 
                            else:                #le premier elt de la liste indique le coin sud
                                self.__grille[y][x].set_image('eau_diago_'+liste[1]+liste[0])
                    elif len(liste)==1:
                        self.__grille[y][x].set_image('eau_coin_'+liste[0])
    
    
    
    ###################    REVELER    ###################
    
    
    def reveler_surface(self, pos):
        assert type(pos) == tuple, 'pos doit être un tuple de quatre éléments (x1, y1, x2, y2)'
        assert len(pos) == 4, 'pos doit être un tuple de quatre éléments (x1, y1, x2, y2)'
        assert pos[0]>=0 and pos[1]>=0 and pos[0]<self.largeur() and pos[1]<self.hauteur(), 'position 1 incorrecte'
        assert pos[2]>=0 and pos[3]>=0 and pos[2]<self.largeur() and pos[3]<self.hauteur(), 'position 2 incorrecte'
        x1, y1, x2, y2 = pos
        for x in range(x1, x2+1):
            for y in range(y1, y2+1):
                if self.get_porte((x,y),'n') is not None:
                    self.get_porte((x,y),'n').reveler()
                if self.get_porte((x,y),'o') is not None:
                    self.get_porte((x,y),'o').reveler()
                if self.__grille[y][x] is not None:
                    self.__grille[y][x].reveler()
        
        for monstre in self.__monstres:
            x=monstre.get_pos_x()
            y=monstre.get_pos_y()
            if x>=x1 and x<=x2 and y>=y1 and y<=y2:
                monstre.reveler()
        
        for personnage in self.__personnages:
            x=personnage.get_pos_x()
            y=personnage.get_pos_y()
            if x>=x1 and x<=x2 and y>y1 and y<=y2:
                personnage.reveler()
        
        for coffre in self.__coffres:
            x=coffre.get_pos_x()
            y=coffre.get_pos_y()
            if x>=x1 and x<=x2 and y>=y1 and y<=y2:
                coffre.reveler()
                
        for objet in self.__objets:
            x=objet.get_pos_x()
            y=objet.get_pos_y()
            if x>=x1 and x<=x2 and y>=y1 and y<=y2:
                objet.reveler()
        
    def verrouiller_porte_surface(self, pos):
        assert type(pos) == tuple, 'pos doit être un tuple de quatre éléments (x1, y1, x2, y2)'
        assert len(pos) == 4, 'pos doit être un tuple de quatre éléments (x1, y1, x2, y2)'
        assert pos[0]>=0 and pos[1]>=0 and pos[0]<self.largeur() and pos[1]<self.hauteur(), 'position 1 incorrecte'
        assert pos[2]>=0 and pos[3]>=0 and pos[2]<self.largeur() and pos[3]<self.hauteur(), 'position 2 incorrecte'
        x1, y1, x2, y2 = pos
        for x in range(x1, x2+2):
            for y in range(y1, y2+2):
                if self.get_porte((x,y),'n') is not None:
                    self.get_porte((x,y),'n').verrouiller_combat()
                if self.get_porte((x,y),'o') is not None:
                    self.get_porte((x,y),'o').verrouiller_combat()
        
        
    
    def reveler_zone(self, pos):
        x, y = pos
        if not self.get((x,y)).est_revele() and self.get((x,y)).image()!='mur':
            self.__grille[y][x].reveler()
            self.__grille[y][x].reveler_piece()
            for orientation in 'nseo':
                if self.get_porte((x,y),orientation) is not None:
                    self.get_porte((x,y),orientation).reveler()
            
            if self.get((x,y-1)) is not None and self.get((x,y-1)).image() == 'mur':
                self.__grille[y-1][x].reveler()
            elif self.get_monstre((x,y-1)) is not None:
                self.reveler_zone((x,y-1))
                self.get_monstre((x,y-1)).reveler()
            elif self.get_personnage((x,y-1)) is not None:
                self.reveler_zone((x,y-1))
                self.get_personnage((x,y-1)).reveler()
            elif self.get_coffre((x,y-1)) is not None:
                self.reveler_zone((x,y-1))
                self.get_coffre((x,y-1)).reveler()
            
            if self.get((x,y+1)) is not None and self.get((x,y+1)).image() == 'mur':
                self.__grille[y+1][x].reveler()
            elif self.get_monstre((x,y+1)) is not None:
                self.reveler_zone((x,y+1))
                self.get_monstre((x,y+1)).reveler()
            elif self.get_personnage((x,y+1)) is not None:
                self.reveler_zone((x,y+1))
                self.get_personnage((x,y+1)).reveler()
            elif self.get_coffre((x,y+1)) is not None:
                self.reveler_zone((x,y+1))
                self.get_coffre((x,y+1)).reveler()
            
            if self.get((x-1,y)) is not None and self.get((x-1,y)).image() == 'mur':
                self.__grille[y][x-1].reveler()
            elif self.get_monstre((x-1,y)) is not None:
                self.reveler_zone((x-1,y))
                self.get_monstre((x-1,y)).reveler()
            elif self.get_personnage((x-1,y)) is not None:
                self.reveler_zone((x-1,y))
                self.get_personnage((x-1,y)).reveler()
            elif self.get_coffre((x-1,y)) is not None:
                self.reveler_zone((x-1,y))
                self.get_coffre((x-1,y)).reveler()
            
            if self.get((x+1,y)) is not None and self.get((x+1,y)).image() == 'mur':
                self.__grille[y][x+1].reveler()
            elif self.get_monstre((x+1,y)) is not None:
                self.reveler_zone((x+1,y))
                self.get_monstre((x+1,y)).reveler()
            elif self.get_personnage((x+1,y)) is not None:
                self.reveler_zone((x+1,y))
                self.get_personnage((x+1,y)).reveler()
            elif self.get_coffre((x+1,y)) is not None:
                self.reveler_zone((x+1,y))
                self.get_coffre((x+1,y)).reveler()

    
    
    
    
    ###################    UPDATE    ###################
    
    
    def update(self, screen):
        """ 
        Affiche les éléments de la carte dans cet ordre:
            - sol
            - portes
            - objets, monstres, personnages et coffres situés derrière le joueur
            - joueur
            - objets, monstres, personnages et coffres situés devant le joueur
            - texte game_over (si self.__game_over == True)
            
        """
        
        #affiche la carte
        
        for y in range(len(self.__grille)):
            for x in range(len(self.__grille[0])):
                case = self.__grille[y][x]
                if case is not None:
                    if case.est_revele():
                        if case.image() is not None:
                            screen.blit(self.__images.get(case.image(),image_vide), (self.__marge_x+ x*50, self.__marge_y+ y*50))
        
        
        
        #affiche les portes
        
        for pos in self.__portes_ns.keys():
            x,y = pos #position du bas de la porte
            porte = self.__portes_ns[pos]
            if porte.est_revele():
                if not porte.est_ouvert():
                    rect = pygame.Rect(self.__marge_x+x*50, self.__marge_y+ y*50 -5, 50, 10) 
                    pygame.draw.rect(screen, (100,50,0),rect)
                else:
                    if porte.get_orientation() == 'n':
                        rect = pygame.Rect(self.__marge_x+(x+1)*50 -10, self.__marge_y+ (y-1)*50 +5, 10, 50)
                        pygame.draw.rect(screen, (100,50,0),rect)
                    else:
                        rect = pygame.Rect(self.__marge_x+(x)*50 , self.__marge_y+ (y)*50 -5, 10, 50)
                        pygame.draw.rect(screen, (100,50,0),rect)
                        
                
        for pos in self.__portes_eo.keys():
            porte = self.__portes_eo[pos]
            x,y = pos #position du côté droit de la porte
            if porte.est_revele():
                
                if not porte.est_ouvert():
                    rect = pygame.Rect(self.__marge_x+x*50 -5, self.__marge_y+ y*50 , 10, 50) 
                    pygame.draw.rect(screen, (100,50,0),rect)
                else:
                    if porte.get_orientation() == 'o':
                        rect = pygame.Rect(self.__marge_x+(x-1)*50+5, self.__marge_y+ y*50 , 50, 10)
                        pygame.draw.rect(screen, (100,50,0),rect)
                    else:
                        rect = pygame.Rect(self.__marge_x+(x)*50 -5, self.__marge_y+ (y+1)*50 -10, 50, 10)
                        pygame.draw.rect(screen, (100,50,0),rect)
                
                
        
        # fait parler les personnages
        
        if time.time() - self.__timer_personnages > 1:
            self.__timer_personnages = time.time()
            for personnage in self.__personnages:
                if personnage.parle():
                    personnage.parler()
        
        
        
        # affiche tous les monstres, personnages et objets situés derrière le joueur
        
        for objet in self.__objets:
            if objet.est_revele() and objet.get_pos_y()<self.joueur.pos_y():
                x,y = self.__marge_image.get(objet.image(),(0,0))
                screen.blit(self.__images.get(objet.image(),image_vide), (self.__marge_x+ objet.get_pos_x()*50+x, self.__marge_y+ objet.get_pos_y()*50+y))
        
        for monstre in self.__monstres:
            if monstre.est_revele() and not monstre.est_mort() and monstre.get_pos_y() < self.joueur.pos_y() :
                screen.blit(self.__images.get(monstre.image(),image_vide), (self.__marge_x+ monstre.get_pos_x()*50-50, self.__marge_y+ monstre.get_pos_y()*50-54))
        
        for personnage in self.__personnages:
            if personnage.est_revele() and not personnage.est_parti() and personnage.get_pos_y() < self.joueur.pos_y():
                screen.blit(self.__images.get(personnage.image(),image_vide), (self.__marge_x+ personnage.get_pos_x()*50+self.__marge_image.get(personnage.image_sans_etat(),(-50,-50))[0], self.__marge_y+ personnage.get_pos_y()*50+self.__marge_image.get(personnage.image_sans_etat(),(-50,-50))[1]))
        
        # affiche les coffres
        
        for coffre in self.__coffres:
            if coffre.est_revele() and  coffre.get_pos_y() < self.joueur.pos_y() :
                x,y = self.__marge_image.get(coffre.image(),(0,0))
                
                screen.blit(self.__images.get(coffre.image(),image_vide), (self.__marge_x+ coffre.get_pos_x()*50+x, self.__marge_y+ coffre.get_pos_y()*50+y))
            
            
        
        #affiche le joueur
        
        if self.joueur.marche(): 
                
            sens = self.joueur.image()
            
            if sens == 'joueur_face': #avance vers le bas
                x= self.__marge_x+ ( self.joueur.pos_x() )*50-5 
                y= self.__marge_y+ ( self.joueur.pos_y()-1 )*50-25 + self.joueur.compteur_pas()*10#12 #marge haut de la carte + l'endroit où le joueur était avant qu'il n'avance + le nombre de pas qu'il a fait depuis qu'il a quitté la case
            elif sens == 'joueur_dos':
                x= self.__marge_x+ ( self.joueur.pos_x() )*50-5 
                y= self.__marge_y+ ( self.joueur.pos_y()+1 )*50-25 - self.joueur.compteur_pas()*10#12
            if sens == 'joueur_profil_droit': #avance vers la droite
                x= self.__marge_x+ ( self.joueur.pos_x()-1 )*50-5 + self.joueur.compteur_pas()*10 #12
                y= self.__marge_y+ ( self.joueur.pos_y() )*50-25 
            elif sens == 'joueur_profil_gauche':
                x= self.__marge_x+ ( self.joueur.pos_x()+1 )*50-5 - self.joueur.compteur_pas()*10#12
                y= self.__marge_y+ ( self.joueur.pos_y() )*50-25 
                
                
            if self.joueur.compteur_pas_total()%2 == 0: #pied droit
                screen.blit(self.__images.get(sens+'_1',image_vide), (x ,y ) )
            else : #nombre de pas impair
                screen.blit(self.__images.get(sens+'_2',image_vide), (x ,y ) )
            
            
            if time.time() - self.__timer_joueur >=0.15: #si 0.15 seconde s'est écoulée depuis le précédent pas
                self.__timer_joueur = time.time()
                self.joueur.avancer()
            
          
        elif self.joueur.tombe():
            
            taille = self.joueur.compteur_chute()
            image = pygame.transform.scale(self.__images.get(self.joueur.image(),image_vide) ,(50-taille, 50-taille)) 
            screen.blit(image,(self.__marge_x+ self.joueur.pos_x()*50-5 + taille , self.__marge_y+ self.joueur.pos_y()*50-25 + taille + taille//2) )
        
            if time.time() - self.__timer_joueur >=0.04: #0.05
                self.__timer_joueur = time.time()
                self.joueur.tomber()
        
        elif self.joueur.se_noie():
            
            sens = self.joueur.image()
            if sens == "joueur_face":
                x=0
                y=-30
            elif sens == "joueur_dos":
                x=0
                y=20
            elif sens == "joueur_profil_droit":
                x=-15
                y=-10
            else:
                x=15
                y=-10
            
            screen.blit(self.__images.get('plouf'+str(self.joueur.compteur_noyade())),(self.__marge_x+ self.joueur.pos_x()*50 + x, self.__marge_y+ self.joueur.pos_y()*50 + y) )
            
            if time.time() - self.__timer_joueur >=0.1:
                self.__timer_joueur = time.time()
                self.joueur.se_noyer()
            
            
        elif self.joueur.est_blesse():
            
            if self.joueur.compteur_blesse()%2 == 0:
                screen.blit(self.__images.get(self.joueur.image(),image_vide), (self.__marge_x+ self.joueur.pos_x()*50-5, self.__marge_y+ self.joueur.pos_y()*50-25))
            
            if time.time() - self.__timer_joueur >=0.15: #0.05
                self.__timer_joueur = time.time()
                self.joueur.clignoter()
            
        
        elif not self.game.vous.est_mort():
            screen.blit(self.__images.get(self.joueur.image(),image_vide), (self.__marge_x+ self.joueur.pos_x()*50-5, self.__marge_y+ self.joueur.pos_y()*50-25))
        
        
        
        # affiche tous les objets, monstres, personnages et coffres situés devant le joueur
        for objet in self.__objets:
            if objet.est_revele() and objet.get_pos_y()>=self.joueur.pos_y():
                x,y = self.__marge_image.get(objet.image(),(0,0))
                screen.blit(self.__images.get(objet.image(),image_vide), (self.__marge_x+ objet.get_pos_x()*50+x, self.__marge_y+ objet.get_pos_y()*50+y))
        
        for monstre in self.__monstres:
            if monstre.est_revele() and not monstre.est_mort() and monstre.get_pos_y() >= self.joueur.pos_y():
                screen.blit(self.__images.get(monstre.image(),image_vide), (self.__marge_x+ monstre.get_pos_x()*50-50, self.__marge_y+ monstre.get_pos_y()*50-54))
        
        for personnage in self.__personnages:
            if personnage.est_revele() and not personnage.est_parti() and personnage.get_pos_y() >= self.joueur.pos_y():
                screen.blit(self.__images.get(personnage.image(),image_vide), (self.__marge_x+ personnage.get_pos_x()*50+self.__marge_image.get(personnage.image_sans_etat(),(-50,-50))[0], self.__marge_y+ personnage.get_pos_y()*50+self.__marge_image.get(personnage.image_sans_etat(),(-50,-50))[1]))
        
        
        for coffre in self.__coffres:
            if coffre.est_revele() and  coffre.get_pos_y() >= self.joueur.pos_y() :
                x,y = self.__marge_image.get(coffre.image(),(0,0))
                screen.blit(self.__images.get(coffre.image(),image_vide), (self.__marge_x+ coffre.get_pos_x()*50+x, self.__marge_y+ coffre.get_pos_y()*50+y))
            
        
        
        
        
        # afficher game_over
        
        if self.__game_over == True:
            image = self.__images.get("game_over",image_vide)
            screen.blit(image, (self.__marge_x +(self.__largeur*50- image.get_width())//2, self.__marge_y + (self.__hauteur*50 - image.get_height())//3))
    
    
    #############    AFFICHAGE EN CONSOLE    #############
    
    
    def __repr__(self):
        return 'Carte()'
    
    def __str__(self):
        chaine=''
        for y in self.__grille:
            for x in y:
                if x is None:
                    chaine += '  '
                else:
                    chaine += ' '+str(x)
            chaine += '\n'
        for pos in self.__portes_ns.keys():
            x,y = pos
            x= x*2+ (y-1)*16*2 +y 
            chaine=chaine[:x]+'_'+chaine[x+1:]
        for pos in self.__portes_eo.keys():
            x,y = pos
            x= x*2+ (y)*16*2 +y
            chaine=chaine[:x]+'|'+chaine[x+1:]
            
        return chaine
    
