# -*- coding: utf-8 -*-
"""
Created on Sat Dec 25 17:25:09 2021

@author: alice
"""

import pygame
import time
from random import randint
from Vous import Vous
from Combat import Combat
from Page import Page

#police et texte
pygame.font.init()
police = pygame.font.Font(None,25)
police2 = pygame.font.Font(None,23)
texte_var = []
texte_var.append(police.render("Habilité",True,pygame.Color("#0000FF")))
texte_var.append(police.render("Endurance",True,pygame.Color("#FF0000")))
texte_var.append(police.render("Chance",True,pygame.Color("#00FF00")))
texte_var.append(police.render("Or",True,pygame.Color("#FFFF00")))
texte_var.append(police.render("Provisions",True,pygame.Color("#FF00FF")))
texte_var.append(police.render("Potion",True,pygame.Color("#FFFFFF")))
texte_var.append(police.render("Inventaire",True,pygame.Color("#FFFFFF")))

#images
epee = pygame.image.load('images/epee-modified.jpg')
epee = pygame.transform.scale(epee, (13,13))




class Game:
    def __init__(self):
        self.running = True
        self.touches_enfoncees = {}

        self.vous = Vous(self)
        self.__combat = Combat(self)


        #focus
        self.__focus_page = False
        self.__fighting = False
        self.__page_a_change = False


        #carte
        self.__cartes = [] #toutes les cartes sont enregistrées ici
        self.__carte = 0 #indice de la carte actuelle


        #recit
        self.__page = None
        self.__page_secondaire = None
        #self.__page_potion = Page(self,"Vous n'avez pas encore de potion",[""])
        texte_commandes = "H : menu d'aide\nP : boire votre potion\nI : ouvrir votre inventaire\n\nse déplacer sur la carte : utiliser les flèches directionnelles de votre clavier\ninteragir avec un objet sur la carte : approchez-vous de l'objet, du texte s'affichera!"
        texte_combat = "Lors d'un combat, les tours se poursuivent jusqu'à ce que vos points d'endurance ou ceux du monstre tombent à 0.\n\nA Chaque tour, vous devez lancer des dés pour determiner votre puissance d'attaque et celle du monstre. Celui qui a la plus grande puissance d'attaque a la possibilité d'attaquer l'autre, qui perd 2 points d'endurance. Vous pouvez ensuite tenter votre chance pour aggraver/atténuer la blessure. Pour en savoir plus, allez dans la section chance du menu d'aide."
        texte_inventaire = "Tous les objets que vous rammassez dans la montagne sont stockés dans votre inventaire.\n\nPour l 'ouvrir, appuyez sur la touche 'I'."
        texte_chance = "Vous pouvez tenter votre chance quand cela vous est proposé ou pendant un combat :\n\nVous lancez deux dés. Si le résultat est inférieur à vos points de chance, vous êtes chanceux, sinon vous êtes malchanceux.\nA chaque fois que vous tentez votre chance, vous perdez un point de chance.\n\n"
        texte_chance_2 = "Lors d'un combat :\n  - si vous êtes chanceux : si le monstre vous a attaqué, vous reprenez un point d'endurance, si c'est vous qui avez attaquez le monstre, il perd deux points d'endurance supplémentaire.\n\n  - Si vous êtes malchanceux : si le monstre vous a attaqué, vous perdez un opint d'endurance supplémentaire, si c'est vous qui avez attaqué le monstre, il regagne un point d'endurance."
        self.__page_aide =  Page(self,"Menu d'aide :",["commandes","potion","inventaire","combat","chance","Retourner au jeu"],{"commandes":Page(self,texte_commandes,['Retourner au jeu']),"potion":Page(self,"Vous n'avez pas encore de potion.",['Retourner au jeu']),"inventaire":Page(self,texte_inventaire,['Retourner au jeu']),"combat":Page(self,texte_combat,['Retourner au jeu']),"chance":Page(self,texte_chance,['suite'],{"suite":Page(self,texte_chance_2,["Retourner au jeu"])})})
        self.__texte_mort = "Quel dommage, vous êtes mort !"

        self.__focus_choix = 0
        self.__timer_texte = time.time()




    ####################    CARTE    ####################


    def carte_actuelle(self):
        return self.__carte

    def ajouter_carte(self,carte):
        self.__cartes.append(carte)

    def changer_carte(self,carte:int,sens:str): #appelé par la classe Joueur quand il sors de la carte
        assert sens in ('n','s','e','o')
        x = self.__cartes[self.__carte].joueur.pos_x()
        y = self.__cartes[self.__carte].joueur.pos_y()

        self.__carte = carte #numéro de la carte
        if sens == 'n':
            self.__cartes[carte].joueur.set_image('joueur_dos')
            self.__cartes[carte].joueur.teleporter((x,self.__cartes[carte].hauteur()-1))
        elif sens == 's':
            self.__cartes[carte].joueur.set_image('joueur_face')
            self.__cartes[carte].joueur.teleporter((x,0))
        elif sens == 'e':
            self.__cartes[carte].joueur.set_image('joueur_profil_droit')
            self.__cartes[carte].joueur.teleporter((0,y))
        elif sens == 'o':
            self.__cartes[carte].joueur.set_image('joueur_profil_gauche')
            self.__cartes[carte].joueur.teleporter((self.__cartes[carte].largeur()-1,y))



    ####################    PAGE    ####################

    def get_page(self):
        return self.__page
    def changer_page(self, page):

        self.__focus_page = True
        self.__focus_choix = 0
        page.effacer()
        self.__page = page
        if self.__fighting:
            self.__page_a_change = True

    def changer_page_secondaire(self, page):
        self.__focus_page = True
        self.__focus_choix = 0
        page.effacer()
        self.__page_secondaire = page

    def aide(self):
        self.changer_page_secondaire(self.__page_aide)
        if self.__page is not None:
            self.__page.effacer()

    def choose_potion(self,potion):
        self.vous.def_type_potion(potion)
        if potion == "potion d'adresse":
            self.__page_aide.set_page_suivante("potion",Page(self, "Votre potion d'adresse vous rend vos points d'habilité de départ.\n\nPour l'utiliser, appuyez sur la touche 'P'.",["Retourner au jeu"]))
        elif potion == "potion de vigueur":
            self.__page_aide.set_page_suivante("potion",Page(self, "Votre potion de vigueur vous rend vos points d'endurance de départ.\n\nPour l'utiliser, appuyez sur la touche 'P'.",["Retourner au jeu"]))
        elif potion == "potion de bonne fortune":
            self.__page_aide.set_page_suivante("potion",Page(self, "Votre potion de bonne fortune vous rend vos points de chance de départ.\n\nPour l'utiliser, appuyez sur la touche 'P'.",["Retourner au jeu"]))


    def potion(self):
        type_potion = self.vous.get_type_potion()
        potion = self.vous.get_potion()
        if type_potion == "":
            self.changer_page_secondaire(Page(self,"Vous n'avez pas encore de potion.",["Ok"]))
        elif potion<=0:
            self.changer_page_secondaire(Page(self,"Votre potion est vide.",[("Ok")]))
        else:
            if type_potion == "potion d'adresse":
                texte = "Il vous reste {} gorgée(s) de potion d'adresse.\n\nVoulez-vous boire votre potion? Vos points d'habilité s'élèveront à {}.".format(potion,self.vous.get_hab_dep())
                texte2 = "Vous buvez une gorgée de votre potion d'adresse.\nVous vous sentez plus fort."
            elif type_potion == "potion de vigueur":
                texte = "Il vous reste {} gorgée(s) de potion de vigeur.\n\nVoulez-vous boire votre potion? Vos points d'endurance s'élèveront à {}.".format(potion,self.vous.get_end_dep())
                texte2 = "Vous buvez une gorgée de votre potion de vigueur.\nQuel goût ignoble!"
            elif type_potion == "potion de bonne fortune":
                texte = "Il vous reste {} gorgée(s) de potion de bonne fortune.\n\nVoulez-vous boire votre potion? Vos points de chance s'élèveront à {}.".format(potion,self.vous.get_cha_dep())
                texte2 = "Vous buvez une gorgée de votre potion de bonne fortune.\nVous ressentez immédiatement une étrange sensation de bien-être. "
            page = Page(self,texte2,["Retourner au jeu"])
            self.changer_page_secondaire(Page(self,texte,["oui","non"],{"oui":page},fonctions={"oui":{"boire_potion":None}}))

    def inventaire(self):
        inv = self.vous.get_inv()
        if len(inv)>400:
            i = 400
            while inv[i]!='\n' and i>0:
                i-=1
            page = Page(self,inv[i+1:],["Retourner au jeu"])
            self.changer_page_secondaire(Page(self,"Inventaire :\n\n"+inv[:i],["suite"],{"suite":page}))
        else:
            self.changer_page_secondaire(Page(self,"Inventaire :\n\n"+inv,["Retourner au jeu"]))

    def repas(self):
        end=self.vous.get_end()
        end_dep=self.vous.get_end_dep()
        page = Page(self,["Manger vous redonne des forces.","Vous enfournez un sandwich.","Vous croquez dans un petit pain.","Miam, miam! Quel délice!"][randint(0,3)],["suite"],fonctions={"suite":{"repas":None}})
        if end == end_dep:
            self.changer_page_secondaire(Page(self,"Vous êtes au top de votre forme !",["Ok"]))
        elif self.vous.get_prov()==0:
            self.changer_page_secondaire(Page(self,"Vos provisions sont vides.",["Ok"]))
        elif end > end_dep-4:
            self.changer_page_secondaire(Page(self,"Voulez-vous prendre un repas ?\n\nVous ne récupèrerez que "+str(end_dep-end)+" point(s) d'endurance.",["Oui","Non"],{"Oui":page},fonctions={"Oui":{"manger":None}}))
        else:
            self.changer_page_secondaire(Page(self,"Voulez-vous prendre un repas ?\n\nVous récupèrerez 4 point(s) d'endurance.",["Oui","Non"],{"Oui":page},fonctions={"Oui":{"manger":None}}))
        self.__page_a_change = True

    def choix_bas(self):
        if self.__focus_page: #si focus sur page
            if self.__page_secondaire is  None: #si page principale (histoire)
                if self.__focus_choix ==len(self.__page.get_boutons())-1:
                    self.__focus_choix = 0
                else:
                    self.__focus_choix += 1
            else: #si page secondaire (commandes)
                if self.__focus_choix ==len(self.__page_secondaire.get_boutons())-1:
                    self.__focus_choix = 0
                else:
                    self.__focus_choix += 1

        elif self.__fighting:
            self.__combat.choix_bas()

    def choix_haut(self):
        if self.__focus_page:
            if self.__page_secondaire is  None:
                if self.__focus_choix ==0:
                    self.__focus_choix = len(self.__page.get_boutons())-1
                else:
                    self.__focus_choix -= 1
            else:
                if self.__focus_choix ==0:
                    self.__focus_choix = len(self.__page_secondaire.get_boutons())-1
                else:
                    self.__focus_choix -= 1

        elif self.__fighting:
            self.__combat.choix_haut()


    def valider_choix(self):
        if self.__focus_page:
            if self.__page_secondaire is None:

                if self.__page.est_ecrit():
                    page = self.__page.get_page_suivante(self.__page.get_boutons()[self.__focus_choix])
                    if page is not None:
                        self.changer_page(page)

                    elif not self.__page_a_change: # le bouton n est pas un lien vers une autre page et on n est pas en combat

                        self.__focus_page = False #pouvoir bouger sur la carte
                        self.__page = None
                    else:
                        self.__page_a_change = False

                else:
                    self.__page.ecrire()
                    if self.__fighting: #permet de retourner au combat (pas de bouton pour quitter)
                        self.__focus_page = False
            else:
                if self.__page_secondaire.est_ecrit():
                    page =self.__page_secondaire.get_page_suivante(self.__page_secondaire.get_boutons()[self.__focus_choix])
                    if page is not None:
                        self.changer_page_secondaire(page)
                    elif not self.__page_a_change:
                        self.__page_secondaire = None
                        if self.__page is None:
                            self.__focus_page = False #retourner à la carte
                        #sinon retourne à la page principale

                        self.__focus_choix = 0
                    self.__page_a_change = False
                else:
                    self.__page_secondaire.ecrire()

        elif self.__fighting:
            self.__combat.valider_choix()

    def afficher_page(self, screen, page):

        if not page.est_ecrit():
            if time.time() - self.__timer_texte > 0.04:
                page.ajouter_lettre()
                if page.est_ecrit() and self.__fighting and self.__page_secondaire is None: #permet de retourner au combat (pas de bouton pour quitter)

                    self.__focus_page = False
                self.__timer_texte = time.time()
        lignes= page.get_texte() #renvoie liste de lignes
        for i in range(len(lignes)): #affiche chaque ligne
            temp = police2.render(lignes[i],True,pygame.Color("#FFFFFF"))
            screen.blit(temp, (35 , 135 + i*23)) #marge gauche, marge haut + nombre de lignes écrites

        if not self.__fighting or self.__page_secondaire is not None: #afficher boutons
            if page.est_ecrit():
                nbr_boutons = page.get_nbr_boutons()
                i+=2 # saute deux lignes
                ligne_du_bouton=[] # numéros des lignes correspondant au debut de chaque bouton

                for k in range(nbr_boutons):
                    ligne_du_bouton.append(i)
                    bouton = page.texte_bouton(k) #renvoie liste de lignes

                    for j in range(len(bouton)): # affiche chaque ligne
                        temp = police2.render(bouton[j],True,pygame.Color("#FFFFFF"))
                        screen.blit(temp, (75 , 135 + i*23)) #marge gauche, marge haut + nombre de lignes écrites
                        i+=1

                #pointeur
                screen.blit(epee, (45, 135 + ligne_du_bouton[self.__focus_choix]*23))


    ###################    COMBAT    ###################

    def nouveau_combat(self,monstre):
        self.__fighting = True
        self.__combat.nouveau_combat(monstre)

    def fin_combat(self):
        self.__fighting = False


    ####################    MORT    ####################


    def changer_texte_mort(self, texte="Quel dommage, vous êtes mort !"):
        self.__texte_mort = texte

    def game_over(self): # utilisé dans la classe Vous
        self.__cartes[self.__carte].game_over()
        self.changer_page(Page(self, self.__texte_mort,["Quitter le jeu"],page_suivante={},fonctions={"Quitter le jeu":{"exit":None}}))

    def quitter_jeu(self):
        self.running = False
        pygame.quit()



    ###################    UPDATE    ###################


    def update(self,screen):

        # afficher rectangles

##        rect = pygame.Rect(20, 120, 300, 450) #cadre récit
##        pygame.draw.rect(screen, (255,255,255), rect, width =2, border_radius = 10)
##
##        for i in range(7): #tableau caractéristiques
##            rect = pygame.Rect(340 + i*114, 20, 114, 50)
##            pygame.draw.rect(screen, (255,255,255), rect, width =2)
##
##        pygame.draw.line(screen, (255,255,255), (340,45), (910,45))

        #texte caractéristique vous -> texte en dehors de la classe

        for i in range(7): # nom caractéristiques
            screen.blit(texte_var[i], (343 + i*114 + (114-texte_var[i].get_rect().width)//2 ,25))

        # valeurs caractéristiques

        temp = police.render( str(self.vous.get_hab()) ,True,pygame.Color("#0000FF"))
        screen.blit(temp, (343 + 0*114 + (114-temp.get_rect().width)//2 ,50))
        temp = police.render( str(self.vous.get_end()) ,True,pygame.Color("#FF0000"))
        screen.blit(temp, (343 + 1*114 + (114-temp.get_rect().width)//2 ,50))
        temp = police.render( str(self.vous.get_cha()) ,True,pygame.Color("#00FF00"))
        screen.blit(temp, (343 + 2*114 + (114-temp.get_rect().width)//2 ,50))
        temp = police.render( str(self.vous.get_or()) ,True,pygame.Color("#FFFF00"))
        screen.blit(temp, (343 + 3*114 + (114-temp.get_rect().width)//2 ,50))
        temp = police.render( str(self.vous.get_prov()) ,True,pygame.Color("#FF00FF"))
        screen.blit(temp, (343 + 4*114 + (114-temp.get_rect().width)//2 ,50))
        temp = police.render("(P)",True,pygame.Color("#FFFFFF"))
        screen.blit(temp, (343 + 5*114 + (114-temp.get_rect().width)//2 ,45))
        temp = police.render("(I)",True,pygame.Color("#FFFFFF"))
        screen.blit(temp, (343 + 6*114 + (114-temp.get_rect().width)//2 ,45))


        if self.__page_secondaire is not None:
            self.afficher_page(screen, self.__page_secondaire)
        elif self.__page is not None:
            self.afficher_page(screen, self.__page)


        # bouger le personnage de la carte
        if not self.__focus_page and not self.__fighting:
            if self.touches_enfoncees.get(pygame.K_UP) == True:
                self.__cartes[self.__carte].joueur.move_top()
            elif self.touches_enfoncees.get(pygame.K_DOWN) == True:
                self.__cartes[self.__carte].joueur.move_bottom()
            elif self.touches_enfoncees.get(pygame.K_LEFT) == True:
                self.__cartes[self.__carte].joueur.move_left()
            elif self.touches_enfoncees.get(pygame.K_RIGHT) == True:
                self.__cartes[self.__carte].joueur.move_right()


        #actualiser la carte/le combat
        if self.__fighting:
            self.__combat.update(screen)
        else:
            self.__cartes[self.__carte].update(screen)



    #############    AFFICHAGE EN CONSOLE    #############


    def __repr__(self):
        return "Game()"

    def __str__(self):
        chaine = ''
        for i in range(len(self.__cartes)):
            chaine += 'carte '+str(i)+' :\n'+str(self.__cartes[i]) + '\n'
        return chaine