# -*- coding: utf-8 -*-



class Joueur: 
    """

    La classe Joueur est la classe qui gère l'avatar du joueur.
    Un exemplaire existe pour chaque Carte().

    La classe qui gère la progression du joueur (endurance, habilité, inventaire, etc.)
    est la classe Vous()'

    """
    def __init__(self, carte):
        self.__carte = carte
        self.__pos_x = 1
        self.__pos_y = 5
        self.__pos_x_precedant = 1
        self.__pox_y_precedant = 5
        self.__marche = False
        self.__chute = False
        self.__noyade = False
        self.__blesse = False
        self.__compteur_pas = -1
        self.__compteur_pas_total = 0
        self.__compteur_chute = 0
        self.__compteur_noyade = 0
        self.__compteur_blesse = 0
        
        self.__image = 'joueur_face'
    
    
    
    ###################    GETTER    ###################
    
    
    def carte(self):
        return self.__carte
    
    def pos_x(self):
        return self.__pos_x
    
    def pos_y(self):
        return self.__pos_y
    
    def marche(self):
        return self.__marche
    
    def tombe(self):
        return self.__chute
    
    def se_noie(self):
        return self.__noyade
    
    def est_blesse(self):
        return self.__blesse
        
    def compteur_pas(self):
        return self.__compteur_pas
    
    def compteur_pas_total(self):
        return self.__compteur_pas_total
    
    def compteur_chute(self):
        return self.__compteur_chute
    
    def compteur_noyade(self):
        return self.__compteur_noyade
    
    def compteur_blesse(self):
        return self.__compteur_blesse
    
    def image(self):
        return self.__image
    
    
    
    ###################    SETTER    ###################
    
    
    def teleporter(self, pos):
        assert pos[0]>=0 and pos[1]>=0 and pos[0]<self.__carte.largeur() and pos[1]<self.__carte.hauteur(), 'position incorrecte'
        self.__pos_x, self.__pos_y = pos
        self.__carte.reveler_zone((self.__pos_x,self.__pos_y))
        
    def blesser(self, x):
        self.__carte.game.vous.blesser(x)
        if not self.__carte.game.vous.est_mort():
            self.__blesse = True
        
        
    def set_image(self,img):
        self.__image = img
        
        
        
    ##################    COMPTEUR    ##################
    
    
    def avancer(self):
        self.__compteur_pas+=1
        self.__compteur_pas_total+=1
        if self.__compteur_pas == 3 and self.__noyade:
            self.__compteur_pas = 0 
            self.__marche = False
            self.__carte.reveler_zone((self.__pos_x,self.__pos_y))
        if self.__compteur_pas == 4:
            self.__carte.reveler_zone((self.__pos_x,self.__pos_y))
        elif self.__compteur_pas == 5:
            self.__compteur_pas = 0 
            self.__marche = False
            
            
            # fermer porte derrière soi
            
            if self.__image == "joueur_face":
                porte =self.__carte.get_porte((self.__pos_x,self.__pos_y),'n')
            elif self.__image == "joueur_dos":
                porte =self.__carte.get_porte((self.__pos_x,self.__pos_y),'s')
            elif self.__image == "joueur_profil_droit":
                porte =self.__carte.get_porte((self.__pos_x,self.__pos_y),'o')
            else:
                porte =self.__carte.get_porte((self.__pos_x,self.__pos_y),'e')
            if porte is not None:
                porte.fermer()
    
    
    def tomber(self):
        self.__compteur_chute +=1
        if self.__compteur_chute ==35:
            self.__compteur_chute = 0
            self.__chute = False
            self.teleporter((self.__pos_x_precedant,self.__pos_y_precedant))
            self.blesser(2)
    
    def se_noyer(self):
        self.__compteur_noyade +=1
        if self.__compteur_noyade == 2:
            self.__compteur_noyade = 0
            self.__noyade = False
            self.teleporter((self.__pos_x_precedant,self.__pos_y_precedant))
            self.blesser(2)
    
    def clignoter(self):
        self.__compteur_blesse +=1
        if self.__compteur_blesse ==8:
            self.__blesse = False
            self.__compteur_blesse = 0
    
    
    
    ##################    DEPLACEMENT    ##################
    
    
    def move_top(self):
        if not self.__marche  and not self.__chute  and not self.__noyade  and not self.__blesse :
            self.__image = 'joueur_dos'
            if self.__pos_y>0:
                porte = self.__carte.get_porte((self.__pos_x,self.__pos_y),'n')
                monstre = self.__carte.get_monstre((self.__pos_x,self.__pos_y-1))
                personnage = self.__carte.get_personnage((self.__pos_x,self.__pos_y-1))
                coffre = self.__carte.get_coffre((self.__pos_x,self.__pos_y-1))
                objet = self.__carte.get_objet((self.__pos_x,self.__pos_y-1))
                sol = self.__carte.get_type((self.__pos_x,self.__pos_y-1))
                if porte is not None and not porte.est_ouvert():
                    self.__carte.game.changer_page(porte.get_page())
                    #porte.page()
                elif coffre is not None:
                    if not coffre.est_ouvert():
                        self.__carte.game.changer_page(coffre.get_page())
                elif monstre is not None and not monstre.est_mort():
                    self.__carte.game.changer_page(monstre.get_page())
                elif personnage is not None and not personnage.est_parti():
                    return
                elif objet is not None:
                    return
                elif sol == 'Chemin()' or sol == 'Herbe()':
                    self.__marche = True
                    self.__pos_y -= 1
                elif sol =='Vide()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__chute = True
                    self.__marche = True
                    self.__pos_y -= 1
                elif sol =='Eau()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__noyade = True
                    self.__marche = True
                    self.__pos_y -= 1    
                
            elif self.__carte.carte_n is not None:
                self.__carte.game.changer_carte(self.__carte.carte_n,'n')
    
    def move_bottom(self):
        if not self.__marche  and not self.__chute  and not self.__noyade  and not self.__blesse:
            self.__image = 'joueur_face'
            if self.__pos_y<self.__carte.hauteur()-1:
                porte = self.__carte.get_porte((self.__pos_x,self.__pos_y),'s')
                monstre = self.__carte.get_monstre((self.__pos_x,self.__pos_y+1))
                personnage = self.__carte.get_personnage((self.__pos_x,self.__pos_y+1))
                coffre = self.__carte.get_coffre((self.__pos_x,self.__pos_y+1))
                objet = self.__carte.get_objet((self.__pos_x,self.__pos_y+1))
                sol = self.__carte.get_type((self.__pos_x,self.__pos_y+1))
                if porte is not None and not porte.est_ouvert():
                    self.__carte.game.changer_page(porte.get_page())
                elif coffre is not None:
                    if not coffre.est_ouvert():
                        self.__carte.game.changer_page(coffre.get_page())
                elif monstre is not None and not monstre.est_mort():
                    self.__carte.game.changer_page(monstre.get_page())
                elif personnage is not None and not personnage.est_parti():
                    return
                elif objet is not None:
                    return
                elif sol == 'Chemin()' or sol == 'Herbe()':
                    self.__marche = True
                    self.__pos_y += 1
                elif sol =='Vide()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__chute = True
                    self.__marche = True
                    self.__pos_y += 1
                elif sol =='Eau()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__noyade = True
                    self.__marche = True
                    self.__pos_y += 1   
            elif self.__carte.carte_s is not None:
                self.__carte.game.changer_carte(self.__carte.carte_s,'s')
            
    def move_left(self):
        if not self.__marche  and not self.__chute  and not self.__noyade  and not self.__blesse:
            self.__image = 'joueur_profil_gauche'
            if self.__pos_x>0:
                porte = self.__carte.get_porte((self.__pos_x,self.__pos_y),'o')
                monstre = self.__carte.get_monstre((self.__pos_x-1,self.__pos_y))
                personnage = self.__carte.get_personnage((self.__pos_x-1,self.__pos_y))
                coffre = self.__carte.get_coffre((self.__pos_x-1,self.__pos_y))
                objet = self.__carte.get_objet((self.__pos_x-1,self.__pos_y))
                sol = self.__carte.get_type((self.__pos_x-1,self.__pos_y))
                if porte is not None and not porte.est_ouvert():
                    self.__carte.game.changer_page(porte.get_page())
                elif coffre is not None:
                    if not coffre.est_ouvert():
                        self.__carte.game.changer_page(coffre.get_page())
                elif monstre is not None and not monstre.est_mort():
                    self.__carte.game.changer_page(monstre.get_page())
                elif personnage is not None and not personnage.est_parti():
                    return
                
                elif objet is not None:
                    return
                elif sol == 'Chemin()' or sol == 'Herbe()':
                    self.__marche = True
                    self.__pos_x -= 1
                elif sol =='Vide()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__chute = True
                    self.__marche = True
                    self.__pos_x -= 1
                elif sol =='Eau()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__noyade = True
                    self.__marche = True
                    self.__pos_x -= 1   
            elif self.__carte.carte_o is not None:
                self.__carte.game.changer_carte(self.__carte.carte_o,'o')
            
    def move_right(self):
        if not self.__marche  and not self.__chute  and not self.__noyade  and not self.__blesse:
            self.__image = 'joueur_profil_droit'
            if self.__pos_x<self.__carte.largeur()-1:
                porte = self.__carte.get_porte((self.__pos_x,self.__pos_y),'e')
                monstre = self.__carte.get_monstre((self.__pos_x+1,self.__pos_y))
                personnage = self.__carte.get_personnage((self.__pos_x+1,self.__pos_y))
                coffre = self.__carte.get_coffre((self.__pos_x+1,self.__pos_y))
                objet = self.__carte.get_objet((self.__pos_x+1,self.__pos_y))
                sol = self.__carte.get_type((self.__pos_x+1,self.__pos_y))
                if porte is not None and not porte.est_ouvert():
                    self.__carte.game.changer_page(porte.get_page())
                elif coffre is not None:
                    if not coffre.est_ouvert():
                        self.__carte.game.changer_page(coffre.get_page())
                elif monstre is not None and not monstre.est_mort():
                    self.__carte.game.changer_page(monstre.get_page())
                elif personnage is not None and not personnage.est_parti():
                    return
                elif objet is not None:
                    return
                
                elif sol == 'Chemin()' or sol == 'Herbe()':
                    self.__marche = True
                    self.__pos_x += 1
                elif sol =='Vide()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__chute = True
                    self.__marche = True
                    self.__pos_x += 1
                elif sol =='Eau()':
                    self.__pos_x_precedant = self.__pos_x
                    self.__pos_y_precedant = self.__pos_y
                    self.__noyade = True
                    self.__marche = True
                    self.__pos_x += 1   
            elif self.__carte.carte_e is not None:
                self.__carte.game.changer_carte(self.__carte.carte_e,'e')
        
        
     
     #############    AFFICHAGE EN CONSOLE    #############   
     
        
    def __repr__(self):
        return 'Joueur()'
    
    def __str__(self):
        return 'J'