# -*- coding: utf-8 -*-

from Page import Page



class Personnage:
    def __init__(self,carte,pos_x:int,pos_y:int, image:str, etat:str):
        """
        Crée un Personnage situé sur la 'carte' ->Carte(), à la position 
        ('pos_x', 'pos_y').
        Le Personnage est représenté sur la carte par l'image 'image' ->str
        
        """
        
        self.__carte = carte
        self.__carte.ajouter_personnage(self)
        self.__pos_x = pos_x
        self.__pos_y = pos_y
        self.__image = image
        self.__revele = False
        self.__piece = None
        
        self.__etat = etat
        self.__compteur_parle = 0
        
        
        
    ############ GETTER #############
    
    def get_pos_x(self):
        return self.__pos_x
    
    def get_pos_y(self):
        return self.__pos_y
    
    def image(self):
        if self.__etat == 'parle':
            return self.__image + '_parle_' + str(self.__compteur_parle)
        return self.__image + '_'+ self.__etat
    
    def image_sans_etat(self):
        return self.__image
    
    def get_etat(self):
        return self.__etat
    
    def parle(self):
        return self.__etat == "parle"
    
    def est_parti(self):
        return self.__etat == "parti"
    
    
    def est_revele(self):
        return self.__revele
    
    
    
    
    ############ SETTER #############
    
    def changer_etat(self, etat):
        self.__etat = etat
        
    def parler(self):
        if self.__compteur_parle == 4:
            self.__compteur_parle = 0
        else:
            self.__compteur_parle += 1
    
    def ajouter_piece(self,piece):
        self.__piece = piece
    
    def reveler(self):
        self.__revele = True
        
    
    
    
    
    ####### méthodes spéciales ########
    
    def __str__(self):
        return "\n\nPersonnage :\n        image : {}".format(self.__image)
    
    def __repr__(self):
        return "Personnage()"
    
    
    
    
    
    
class Monstre:
    def __init__(self,carte,pos_x:int,pos_y:int, image:str,nom:str,hab:int,end:int,phrase_attaque:list, particularite=None, endormi=False, texte='', texte_mort=None, texte_victoire=None, recompense={}):
        """
        Crée un Monstre situé sur la 'carte' ->Carte(), à la position 
        ('pos_x', 'pos_y').
        Le Monstre est représenté sur la carte par l'image 'image' ->str
        
        Les caractéristiques du Monstre sont les suivantes:
            - nom : str
            - hab : int
            - end : int
            - phrase_attaque : list   (contient les différentes phrases d'attaque du Monstre. 
                                       A chaque fois que le Monstre gagnera un tour dans un combat,
                                       une de ses phrases d'attaque sera affichée au hasard)
                                       
            - particularite : str     (les particularités possibles sont:
                                           - 'ivresse')
            
        Si le Monstre est 'endormi' ->bool, l'image affichée sur la carte
        sera différente jusqu'à ce qu'il soit réveillé, et, dans certain cas,
        le joueur n'aura la possibilité de fuir que si le Monstre est endormi.
        
        
        la variable 'texte' ->str contient le texte affiché lorsque le Joueur
        s'approche du Monstre.
        'texte_mort' ->str contient le texte affiché si le joueur perd le combat
        'texte_victoire ->str contient le texte affiché si le joueur gagne le combat
        
        'recompense' ->dict contient les méthodes qui sont appelées lorsque le joueur gagne.
        les clés correspondent à des mot-clés, chacun associé à une méthode du joueur Vous()
        et dont les valeurs correspondent aux arguments :
            - hab : int
            - end : int
            - cha : int
            - or  : int
            - inv : {"nom de l'objet" : "description"}
        

        """
        
        self.__carte = carte
        self.__carte.ajouter_monstre(self)
        self.__pos_x = pos_x
        self.__pos_y = pos_y
        self.__image = image
        self.__endormi = endormi
        self.__revele = False
        self.__mort = False
        self.__piece = None
        
        
        
        self.__nom=nom
        self.__habilite=hab
        self.__endurance=end
        
        self.__phrase_attaque=phrase_attaque
        self.__particularite=particularite
        
        
        
        self.__page = Page(self.__carte.game, texte+"Voulez-vous combattre ce monstre ?", ['Oui','Non'], fonctions={'Oui':{'combattre':self}})
        self.__texte_victoire = texte_victoire
        self.__recompense = recompense
        if texte_mort is None:
            self.__texte_mort = "Le monstre vous tue."
        else:
            self.__texte_mort = texte_mort
        
        
    ############ GETTER #############
    
    def get_pos_x(self):
        return self.__pos_x
    
    def get_pos_y(self):
        return self.__pos_y
    
    def image(self):
        if self.__endormi:
            return self.__image+"_endormi"
        return self.__image
    
    def est_endormi(self):
        return self.__endormi
    
    def est_revele(self):
        return self.__revele
    
    def est_mort(self):
        return self.__mort
    
    
    def get_nom(self):
        return self.__nom
    
    def get_hab(self):
        return self.__habilite
    
    def get_end(self):
        return self.__endurance
    
    def get_phrase_attaque(self):
        return self.__phrase_attaque
    
    def fait_fuire(self):
        return self.__fuite
    
    def get_particularite(self):
        return self.__particularite
    
    def get_power(self):
        return self.__puissance_attaque
    
    
    
    def get_page(self):
        return self.__page
    
    def get_texte_mort(self):
        return self.__texte_mort
    
    def get_page_victoire(self):
        if self.__texte_victoire is None:
            return Page(self.__carte.game,"Le monstre s'écroule sur le sol.",['Ok'],fonctions={'Ok':self.__recompense})
        else:
            return Page(self.__carte.game,self.__texte_victoire,['Ok'],fonctions={'Ok':self.__recompense})
        
    
    ############ SETTER #############
    
    
    def ajouter_piece(self,piece):
        self.__piece = piece
    
    def reveler(self):
        self.__revele = True
        
    def reveiller(self):
        self.__endormi = False
    
    def blesser(self,x):
        assert type(x)==int
        self.__endurance -= x
        
    def mourir(self):
        self.__mort = True
        if self.__piece is not None:
            self.__piece.tenter_deverrouiller()
    
     
    
    ####### méthodes spéciales ########
    
    def __str__(self):
        return "\n\n        image : {}\n        habilite : {}\n        endurance : {}\n        particularité : {}\n\n".format(self.__image,self.__habilite,self.__endurance,self.__particularite)
    
    def __repr__(self):
        return "Monstre()"
