# -*- coding: utf-8 -*-

from Page import Page
from random import randint



class Porte:
    def __init__(self, carte, pos_x, pos_y, orientation:str, texte='', resistance=False):
        """
        La porte est située sur la 'carte'->Carte(), à la position
        'pos'->(x,y).
        la porte est dessinée au nord, au sud, à l'est ou à
        l'ouest de la case en fonction de l'orientation indiquée.
        L'orientation peut être :
            ['n', 's', 'e', 'o']
        La porte peut être accompagnée d'un texte à indiquer dans
        la chaine 'texte' qui s'affichera lorsque le Joueur s'approchera
        de la porte.
        Si la 'resistance' de la porte est True, le joueur devra
        lancer des dés pour tenter de la forcer.
        """
        assert orientation in ['n','s','e','o']
        self.__carte = carte
        self.__pos_x = pos_x
        self.__pos_y = pos_y
        self.__orientation = orientation
        self.__resistance = resistance
        self.__ouvert = False
        self.__deja_ouvert = False
        self.__revele = False
        self.__change_etat = False
        self.__verrouillee = False
        self.__verrouillee_combat = False
        
        self.__carte.ajouter_porte(self)

        if not resistance :
            if texte=='':
                self.__page = Page(self.__carte.game,"Voulez-vous ouvrir cette porte?",boutons=['Oui','Non'],fonctions={'Oui':{'ouvrir':self}})
            else:
                self.__page = Page(self.__carte.game,texte+"\n\nVoulez-vous ouvrir cette porte?",boutons=['Oui','Non'],fonctions={'Oui':{'ouvrir':self}})
        else:
            page_temp = Page(self.__carte.game,"Vous tentez d'enfoncer la porte à coup d'épaule.\nLancez deux dés pour déterminer la résistance de la porte. Le résultat obtenu doit être inférieur à vos points d'habilités pour pouvoir l'ouvrir.",['Lancer les dés.'],fonctions={'Lancer les dés.':{'forcer_porte':self}})
            if texte == "":
                self.__page = Page(self.__carte.game,"La porte est verrouillée. Voulez-vous tenter de la forcer ?",['Oui','Non'],page_suivante={'Oui':page_temp})
            else:
                self.__page = Page(self.__carte.game,texte+"\n\nLa porte est verrouillée. Voulez-vous tenter de la forcer ?",['Oui','Non'],page_suivante={'Oui':page_temp})
    
    def get_pos_x(self):
        return self.__pos_x
    
    def get_pos_y(self):
        return self.__pos_y
    
    def get_orientation(self):
        return self.__orientation
    
    def get_page(self):

        if self.__change_etat:
            self.__change_etat = False
            if self.__verrouillee_combat:
                self.__verrouillee_combat = False
                self.__page = Page(self.__carte.game,"Si vous tentez de fuir, le(s) monstre(s) aura(auront) la possibilité de vous attaquer et vous perdrez deux points d'endurance.\nÊtes-vous sûr de vouloir quitter la pièce?",['Oui','Non'],fonctions={'Oui':{'ouvrir':self,'deverrouiller_porte':self, 'end':-2}})
            elif self.__verrouillee:
                self.__verrouillee = False
                self.__page = Page(self.__carte.game,"La porte est vérouillée.",['Ok'])
            else:
                self.__page = Page(self.__carte.game,"Voulez-vous ouvrir cette porte?",boutons=['Oui','Non'],fonctions={'Oui':{'ouvrir':self}})

        return self.__page

    def est_ouvert(self):
        return self.__ouvert

    def ouvrir(self):
        self.__ouvert = True
        if not self.__deja_ouvert:
            self.__deja_ouvert = True
            self.deverrouiller()

    def fermer(self):
        self.__ouvert = False

    def forcer(self):
        des = randint(1,6)+randint(1,6)

        if self.__carte.game.vous.est_assez_fort(des):
            self.deverrouiller()
            page_temp=Page(self.__carte.game,"Vous obtenez "+str(des)+" !\n\nVous parvenez à ouvrir la porte.",['ok'],fonctions={'ok':{'ouvrir':self}})
        else:
            self.verrouiller()
            page_temp=Page(self.__carte.game,"Vous obtenez "+str(des)+" !\n\nLa porte résiste. Vous ne parvenez qu'à vous faire mal à l'épaule.",['ok'],fonctions={'ok':{'end':-2}})
        self.__page.get_page_suivante('Oui').set_page_suivante('Lancer les dés.',page_temp)

    def deverrouiller(self):
        self.__change_etat = True
        self.__verrouillee = False
        self.__verrouillee_combat = False

    def verrouiller(self):
        self.__change_etat = True
        self.__verrouillee = True

    def verrouiller_combat(self):
        """
        si le joueur tente d'ouvrir la porte,
        il perdra deux points d'endurance.
        """
        self.__change_etat = True
        self.__verrouillee_combat = True



    def est_revele(self):
        return self.__revele

    def reveler(self):
        if self.__revele == False:
            self.__revele = True





class Coffre:
    def __init__(self,carte,pos_x,pos_y,image,texte='',page_ouverture=None,recompense={},verrouille=False):
        self.__carte=carte
        self.__carte.ajouter_coffre(self)
        self.__pos_x = pos_x
        self.__pos_y = pos_y
        self.__image = image
        self.__ouvert = False
        self.__revele = False
        self.__change_etat = False
        self.__verrouille = False
        self.__recompense = dict(recompense)
        self.__recompense['ouvrir']=self
        if texte == '':
            self.__texte = "Voulez-vous ouvrir ce coffre?"
        else:
            self.__texte = texte


        if page_ouverture is None:
            texte=''
            if recompense=={}:
                texte='Le coffre est vide.'
            for key in recompense.keys():
                if key == "inv":
                    texte +="Vous récupérez l'objet "+str(recompense[key])+".\n"
                elif key == "or":
                    texte +='Vous récupérez '+str(recompense[key])+" piece(s) d'or.\n"
                elif key == "hab":
                    texte +='Vous récupérez '+str(recompense[key])+" point(s) d'habilité.\n"
                elif key == "end":
                    texte +='Vous récupérez '+str(recompense[key])+" point(s) d'endurance.\n"
                elif key == "cha":
                    texte +='Vous récupérez '+str(recompense[key])+' point(s) de chance.\n'

            self.__page_ouverture=Page(self.__carte.game,texte,['Ok'])
        else:
            self.__page_ouverture=page_ouverture


        if self.__verrouille:
            self.__page = Page(self.__carte.game, "Ce coffre est vérrouillé. Vous devez tuer tous les monstres de la zone pour pouvoir l'ouvrir.",['Ok'])
        else:
            self.__page = Page(self.__carte.game,self.__texte,['Oui','Non'],page_suivante={'Oui':self.__page_ouverture},fonctions={'Oui':self.__recompense})
    
    
    def get_pos_x(self):
        return self.__pos_x
    
    def get_pos_y(self):
        return self.__pos_y

    def image(self):
        if self.est_ouvert():
            return self.__image+"_ouvert"
        return self.__image
    
    def get_page(self):
        if self.__change_etat:
            self.__change_etat = False
            if self.__verrouille:
                self.__page = Page(self.__carte.game, "Ce coffre est vérrouillé. Vous devez tuer tous les monstres de la zone pour pouvoir l'ouvrir.",['Ok'])
            else:
                self.__page = Page(self.__carte.game,self.__texte,['Oui','Non'],page_suivante={'Oui':self.__page_ouverture},fonctions={'Oui':self.__recompense})
        
        return self.__page

    def est_ouvert(self):
        return self.__ouvert

    def ouvrir(self):
        self.__ouvert = True
        self.__page = None
        
        
    def deverrouiller(self):
        self.__change_etat = True
        self.__verrouille = False
        
    def verrouiller(self):
        self.__change_etat = True
        self.__verrouille = True
        
    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        self.__revele = True
        
        
        
class Objet:
    def __init__(self,carte, pos_x,pos_y,image):
        self.__carte=carte
        self.__carte.ajouter_objet(self)
        self.__pos_x = pos_x
        self.__pos_y = pos_y
        self.__image = image
        self.__revele = False
        
    def get_pos_x(self):
        return self.__pos_x
    
    def get_pos_y(self):
        return self.__pos_y
    
    def image(self):
        return self.__image
    
    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        self.__revele = True