# -*- coding: utf-8 -*-

from random import randint



def sauter_des_lignes(chaine,a):
    L=[]
    debut=0
    i=0
    n=0
    while i<len(chaine):
        if chaine[i]=="\n":
            n=0
            L.append(chaine[debut:i])#
            debut = i+1
        else:
            n+=1

        if n>=a:
            n=0
            while chaine[i]!=" " and i>=0:
                i-=1
            L.append(chaine[debut:i])
            debut=i+1
        i+=1
    L.append(chaine[debut:])
    return L



class Page:



    def __init__(self, game, texte:str,boutons:list,page_suivante={} , fonctions:dict={}):
        """
        Le texte du récit (affiché dans le rectangle à gauche de la carte)
        est enregistré dans la variable 'texte'.

        Il est suivi d'au moins un choix, consigné(s) dans la liste 'boutons'.

        Le dictionnaire 'page_suivante' associe à chaque bouton une autre Page().
        Si la valeur associée à un bouton est None, le dialogue avec l'utilisateur se
        termine et il peut à nouveau se déplacer sur la carte.

        Le dictionnaire 'fonctions' permet d'appeler les méthodes du joueur Vous(),
        du Game(), d'un Monstre(), d'un Personnage(), d'un Coffre(), d'une Piece() ou d'une Porte().
        Il associe à chaque bouton un dictionnaire contenant les méthodes à appeler dont
        les clés correspondent à des mot-clés chacun associé à une méthode et dont les
        valeurs correspondent aux arguments :
            - choose_potion : "potion d'adresse" or "portion de vigeur" or "potion de bonne fortune"
            - boire_potion : None
            - hab : int
            - end : int
            - cha : int
            - or  : int
            - inv : ("nom de l'objet", "description")
            - retirer_inv : "nom de l'objet"
            - repas : None
            - manger : None

            - tenter_chance : {True : Page(), False : Page()}

            - combattre : Monstre()
            - tuer : (Monstre(), Monstre(), ..., Monstre())
            
            - changer_etat : (Personnage(), "etat")

            - ouvrir : Coffre()

            - verrouiller_piece : Piece
            - deverrouiller_piece : Piece
            - tenter_deverrouiller_piece : Piece

            - ouvrir : Porte()
            - forcer_porte : Porte()
            - deverrouiller_porte : Porte()

            - exit : None

        """
        assert boutons != [], "la liste boutons doit comporter au moins un élément"
        for key in page_suivante.keys():
            assert key in boutons, "la clé '"+str(key)+"' du dico 'page_suivante' ne correspond à aucun bouton."

        for key in fonctions.keys():
            assert key in boutons, "la clé '"+str(key)+"' du dico 'fonctions' ne correspond à aucun bouton."

        for dico in fonctions.values():
            for key in dico.keys():
                assert key in ["choose_potion","boire_potion","hab","end","cha","or","inv","retirer_inv","repas", "manger", 'tenter_chance',"combattre","tuer","changer_etat",'verrouiller_piece','deverrouiller_piece','tenter_deverrouiller_piece',"ouvrir","forcer_porte","deverrouiller_porte","exit"], "la fonction '"+str(key)+"' n'existe pas.\n les fonctions possibles sont :\n[choose_potion, boire_potion, hab, end, cha, or, inv, retirer_inv, repas, manger, tenter_chance, combattre, tuer, changer_etat, verrouiller_piece, deverrouiller_piece, tenter_deverrouiller_piece, ouvrir, forcer_porte, deverrouiller_porte, exit]."



        self.__game = game
        self.__texte = sauter_des_lignes(texte,36) #liste de ligne de 36 caractères maximum
        self.__boutons = boutons
        self.__dico_page_suivante = dict(page_suivante)
        self.__fonctions = dict(fonctions)
        self.__dico = {}

        self.__writing = True
        self.__ligne = 0
        self.__lettre = 0



    def get_page_suivante(self,bouton):
        """
        Appelle les fonctions et renvoie la Page()
        associés au bouton.
        """
        self.appeler_fonctions(self.__fonctions.get(bouton))
        return self.__dico_page_suivante.get(bouton)

    def set_page_suivante(self, bouton, page):
        self.__dico_page_suivante[bouton]=page

    def set_fonctions(self, bouton, fonction):
        self.__fonctions[bouton]=fonction

    def est_ecrit(self):
        return not(self.__writing)

    def ajouter_lettre(self):
        if self.__lettre<len(self.__texte[self.__ligne])-1:
            self.__lettre +=1
        elif self.__ligne<len(self.__texte)-1:
            self.__lettre=0
            self.__ligne +=1
        else:
            self.__writing = False

    def effacer(self):
        self.__ligne = 0
        self.__lettre = 0
        self.__writing = True

    def ecrire(self):
        self.__ligne = len(self.__texte)-1
        self.__lettre = len(self.__texte[self.__ligne])-1
        self.__writing = False

    def get_texte(self):
        return self.__texte[:self.__ligne] + [self.__texte[self.__ligne][:self.__lettre+1]] #[n-1 premiere ligne] + [n' premieres lettres de la nème ligne]

    def texte_bouton(self,i):
        return sauter_des_lignes(self.__boutons[i],30)

    def get_boutons(self):
        return self.__boutons
    
    def get_nbr_boutons(self):
        return len(self.__boutons)

    def nbr_boutons(self):
        return len(self.__boutons)

    def appeler_fonctions(self, dico_fonctions):
        if dico_fonctions is not None:
            for key in dico_fonctions.keys():
                if key == "choose_potion":
                    self.__game.choose_potion(dico_fonctions[key])
                elif key == "boire_potion":
                    self.__game.vous.boire_potion()
                elif key == "hab":
                    self.__game.vous.aug_hab( dico_fonctions[key] )
                elif key == "end":
                    self.__game.vous.aug_end( dico_fonctions[key] )
                elif key == "cha":
                    self.__game.vous.aug_cha( dico_fonctions[key] )
                elif key == "or":
                    self.__game.vous.aug_or( dico_fonctions[key] )
                elif key == "inv":
                    self.__game.vous.add_inv( dico_fonctions[key] )
                elif key == "retirer_inv":
                    self.__game.vous.retirer_inv(dico_fonctions[key])
                elif key == "repas":
                    self.__game.repas()
                elif key == "manger":
                    self.__game.vous.mange()

                elif key == "tenter_chance":
                    des = randint(1,6) + randint(1,6)
                    chanceux = self.__game.vous.est_chanceux(des)
                    if chanceux:
                        page=Page(self.__game,'Vous obtenez '+str(des)+'!\n\nVous êtes chanceux!',['Ok'],page_suivante={'Ok':dico_fonctions[key].get(True)})
                    else :
                        page=Page(self.__game,'Vous obtenez '+str(des)+'!\n\nVous êtes malchanceux!',['Ok'],page_suivante={'Ok':dico_fonctions[key].get(False)})

                    page = Page(self.__game,"Vous tentez votre chance.\n\nLancez deux dés. Si ce résultat est inféreur ou égal à vos points de chance, vous êtes chaneux. Dans le cas contraire, vous êtes malchanceux.\nDans tous les cas, vous perdrez un point de chance",['Lancez les dés'],page_suivante={'Lancez les dés':page},fonctions={'Lancez les dés':{'cha':-1}})
                    self.set_page_suivante('Tenter votre chance',page)

                elif key == 'combattre':
                    self.__game.nouveau_combat(dico_fonctions[key])
                elif key == "tuer":
                    for monstre in dico_fonctions[key]:
                        monstre.mourir()
                elif key == 'changer_etat':
                    dico_fonctions[key][0].changer_etat(dico_fonctions[key][1])

                elif key == 'verrouiller_piece':
                    dico_fonctions[key].verrouiller()
                elif key == 'deverrouiller_piece':
                    dico_fonctions[key].deverrouiller()
                elif key == 'tenter_deverrouiller_piece':
                    dico_fonctions[key].tenter_deverrouiller()

                elif key == "ouvrir":
                    dico_fonctions[key].ouvrir()
                elif key == 'forcer_porte':
                    dico_fonctions[key].forcer()
                elif key == 'deverrouiller_porte':
                    dico_fonctions[key].deverrouiller()
                elif key == "exit":
                    self.__game.quitter_jeu()



    def __repr__(self):
        return "Page()"

    def __str__(self):
        chaine = ''
        for elt in self.__texte:
            chaine += elt+"\n"
        if chaine == '':
            return "vide"
        return chaine