# -*- coding: utf-8 -*-



class Piece:

    def __init__(self, carte, x1, y1, x2, y2, page=None, arene=False):
        
        
        assert x1>=0 and y1>=0 and x1<carte.largeur() and y1<carte.hauteur(), 'position 1 incorrecte'
        assert x2>=0 and y2>=0 and x2<carte.largeur() and y2<carte.hauteur(), 'position 2 incorrecte'
        
        self.__carte = carte
        
        self.__page = page
        self.__pos_x1 = x1
        self.__pos_y1 = y1
        self.__pos_x2 = x2
        self.__pos_y2 = y2
        self.__revelee = False
        self.__arene = arene

        self.__monstres =  []
        self.__coffres = []
        self.__portes = []
        
        
        self.__carte.ajouter_piece(self)
        for x in range(x1,x2+1):
            for y in range(y1,y2+1):
                monstre = self.__carte.get_monstre((x,y))
                coffre = self.__carte.get_coffre((x,y))
                porte = self.__carte.get_porte((x,y),'n')
                if porte is None:
                    porte=self.__carte.get_porte((x,y),'o')
                if monstre is not None:
                    self.__monstres.append(monstre)
                    monstre.ajouter_piece(self)
                elif porte is not None:
                    self.__portes.append(porte)
                elif coffre is not None:
                    self.__coffres.append(coffre)
                    
                    
            porte = self.__carte.get_porte((x,y2+1),'n')
            if porte is not None:
                self.__portes.append(porte)
        
        for y in range(y1,y2+1):
            porte = self.__carte.get_porte((x2+1,y),'o')
            if porte is not None:
                self.__portes.append(porte)
        
        if self.__monstres != []:
            for coffre in self.__coffres:
                coffre.verrouiller()
    
    def get_surface(self):
        return self.__pos_x1, self.__pos_y1, self.__pos_x2, self.__pos_y2


    def ajouter_page(self,page):
        self.__page=page


    def verrouiller(self):
        for porte in self.__portes:
            porte.fermer()
            porte.verrouiller_combat()
        for coffre in self.__coffres:
            coffre.verrouiller()
        for monstre in self.__monstres:
            monstre.reveiller()

    def deverrouiller(self):
        for porte in self.__portes:
            porte.deverrouiller()
        for coffre in self.__coffres:
            
            coffre.deverrouiller()

    def tenter_deverrouiller(self):
        for monstre in self.__monstres:
            if not monstre.est_mort():
                return
        self.deverrouiller()

    def reveler(self):
        if not self.__revelee:
            self.__revelee = True
            self.__carte.reveler_surface((self.__pos_x1, self.__pos_y1, self.__pos_x2, self.__pos_y2 ))
            if self.__arene:
                self.verrouiller()
            if self.__page is not None:
                self.__carte.game.changer_page(self.__page)
