# -*- coding: utf-8 -*-



class Chemin:
    def __init__(self,carte, pos : tuple,camoufle=False):
        self.__carte = carte
        if camoufle:
            self.__image = 'mur'
        else:
            self.__image = 'chemin'
        self.__piece = None
        self.__revele = False

    def image(self):
        return self.__image

    def ajouter_piece(self, piece):
        self.__piece = piece

    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        self.__revele = True
    
    def reveler_piece(self):
        if self.__piece is not None:
            self.__piece.reveler()
     
        
        
    def __repr__(self):
        return 'Chemin()'
    
    def __str__(self):
        if self.__image == 'mur':
            return 'X'
        return '='
    
    
    
class Mur:
    def __init__(self,carte, pos : tuple):
        self.__carte = carte
        self.__image = 'mur'
        self.__piece = None
        self.__revele = False
    
    def image(self):
        return self.__image

    def ajouter_piece(self, piece):
        self.__piece = piece

    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        if self.__revele == False:
            self.__revele = True
        
    def reveler_piece(self):
        if self.__piece is not None:
            self.__piece.reveler()
    
     
        
    def __repr__(self):
        return 'Mur()'
    
    def __str__(self):
        return 'X'



class Herbe:
    def __init__(self,carte, pos : tuple):
        self.__carte = carte
        self.__image = 'herbe'
        self.__piece = None
        self.__revele = False

    def image(self):
        return self.__image
   
    def ajouter_piece(self, piece):
        self.__piece = piece
        
    def set_image(self,img):
        self.__image = img

    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        if self.__revele == False:
            self.__revele = True
        
    def reveler_piece(self):
        if self.__piece is not None:
            self.__piece.reveler()
        
     
        
    def __repr__(self):
        return 'Herbe()'
    
    def __str__(self):
        return '+'
    
    
    
class Eau:
    def __init__(self,carte, pos : tuple):
        self.__carte = carte
        self.__image = 'eau'
        self.__piece = None
        self.__revele = False

    def image(self):
        return self.__image

    def ajouter_piece(self, piece):
        self.__piece = piece
        
    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        if self.__revele == False:
            self.__revele = True
        
    def reveler_piece(self):
        if self.__piece is not None:
            self.__piece.reveler()
        
     
        
    def __repr__(self):
        return 'Eau()'
    
    def __str__(self):
        return '~'



class Vide:
    def __init__(self,carte, pos : tuple):
        self.__carte = carte
        self.__image = None
        self.__piece = None
        self.__revele = False

    def image(self):
        return self.__image

    def ajouter_piece(self, piece):
        self.__piece = piece
        
    def est_revele(self):
        return self.__revele
    
    def reveler(self):
        if self.__revele == False:
            self.__revele = True
        
    def reveler_piece(self):
        if self.__piece is not None:
            self.__piece.reveler()
     
        
        
    def __repr__(self):
        return 'Vide()'
    
    def __str__(self):
        return ' '