# -*- coding: utf-8 -*-

from random import randint



class Vous:
    def __init__(self, game, adversaire=None):
        self.game = game
        self.__habilite_depart = 6 + randint(1,6)
        self.__endurance_depart = 12 + randint(1,6)+randint(1,6)
        self.__chance_depart = 6 + randint(1,6)

        self.__habilite = self.__habilite_depart
        self.__endurance = self.__endurance_depart
        self.__chance = self.__chance_depart

        self.__or = 2
        self.__provisions = 10
        self.__type_potion = ""
        self.__potion = 2

        self.__inventaire = {'épée':' (équipement de base)','bouclier':' (équipement de base)'}

        self.__phrase_attaque = ["Votre épée s'enfonce dans la chair de votre adversaire","Votre adversaire baisse la garde, vous en profitez pour l'attaquer"]
        self.__puissance_attaque = 0

        self.__adversaire = adversaire


    ############ GETTER #############

    def get_hab(self):
        return self.__habilite

    def get_end(self):
        return self.__endurance

    def get_cha(self):
        return self.__chance

    def get_hab_dep(self):
        return self.__habilite_depart

    def get_end_dep(self):
        return self.__endurance_depart

    def get_cha_dep(self):
        return self.__chance_depart

    def est_mort(self):
        return self.__endurance<=0



    def get_or(self):
        return self.__or

    def get_prov(self):
        return self.__provisions

    def get_type_potion(self):
        return self.__type_potion

    def get_potion(self):
        return self.__potion



    def get_inv(self):
        """Renvoie une chaîne contenant le contenu de l'inventaire.
        Renvoie d'abord l'épée du joueur, puis le bouclier du joueur,
        puis l'arc du joueur s'il en possède un, puis le reste de son équipement."""

        chaine="          - épée"+self.__inventaire["épée"]+"\n"

        if "bouclier" in self.__inventaire.keys():
            chaine=chaine+"          - bouclier"+self.__inventaire["bouclier"]+"\n"

        elif "bouclier de lune" in self.__inventaire.keys():
            chaine=chaine+"          - bouclier de lune"+self.__inventaire["bouclier de lune"]+"\n"

        if "Arc et flèche d'argent"in self.__inventaire.keys():
            chaine=chaine+"          - Arc et flèche d'argent"+self.__inventaire["Arc et flèche d'argent"]+"\n"

        for cle in self.__inventaire.keys():
            if cle!="épée" and cle!="bouclier" and cle!="bouclier de lune" and cle!="Arc et flèche d'argent":
                chaine=chaine+"          - "+cle+self.__inventaire[cle]+"\n"
        
        return chaine

    def possede(self,cle):
        return cle in self.__inventaire





    ############ CHANCE #############

    def est_chanceux(self, des):
        return des <= self.__chance

    def est_assez_fort(self, des):
        return des <= self.__habilite





    ############ SETTER #############

    def aug_hab(self,x):
        assert type(x)==int
        self.__habilite += x

    def aug_end(self,x):
        assert type(x)==int
        self.__endurance += x
        if self.est_mort():
            self.game.game_over()

    def aug_cha(self,x):
        assert type(x)==int
        self.__chance += x

    def aug_or(self,x):
        assert type(x)==int
        self.__or += x

    def blesser(self,x):
        assert type(x)==int
        self.__endurance -= x
        if self.est_mort():
            self.game.game_over()
    
    def mourir(self):
        self.__endurance = 0
        self.game.game_over()
        
    def set_hab(self,x):
        self.__habilite = x
        
    def set_end(self, x):
        self.__endurance = x
    
    def set_cha(self,x):
        assert type(x)==int
        self.__chance = x
        

    def mange(self):
        assert self.__provisions>0, "les provisions sont vides"

        if self.__endurance+4 > self.__endurance_depart:
            self.__endurance = self.__endurance_depart
        else:
            self.__endurance += 4

        self.__provisions-=1




    def def_type_potion(self, potion):
        assert potion in ["potion de vigueur", "potion d'adresse", "potion de bonne fortune"]
        self.__type_potion = potion


    def boire_potion(self):
        assert self.__potion>0, "la potion est vide"

        if self.__type_potion=="potion d'adresse":
            self.__habilite=self.__habilite_depart

        elif self.__type_potion=="potion de vigueur":
            self.__endurance=self.__endurance_depart

        elif self.__type_potion=="potion de bonne fortune":
            self.__chance_depart+=1
            self.__chance=self.__chance_depart

        self.__potion-=1



    def add_inv(self, couple):
        cle, elt = couple
        self.__inventaire[cle]=elt

    def retirer_inv(self, cle):
        if cle in self.__inventaire:
            del self.__inventaire[cle]





    ####### méthodes spéciales ########

    def __str__(self):
        return "\nhabilite : {}\nendurance : {}\nchance : {}\n\nor : {}\nprovision(s) : {}\npotion : {} ({})\n\ninventaire : {}".format(self.__habilite,self.__endurance,self.__chance,self.__or,self.__provisions, self.__type_potion, self.__potion,[cle for cle in self.__inventaire.keys()])

    def __repr__(self):
        return "Joueur()"