# -*- coding: utf-8 -*-

"""

Bonjour !
Pour jouer au Sorcier de la Montagne de Feu, vous êtes au bon endroit !
Lancez ce script et la fenetre du jeu apparaitra!


P.S. : Parviendrez-vous à atteindre la pièce secrète?
       Un indice : cherchez du côté du mur à gauche de l'avant dernière case
       la plus au nord. Attention cependant, il fait très noir dans le 
       passage...
       
P.P.S : Sur certains ordinateurs, le lancement de ce scipt lèvera une erreur.
        Si c'est le cas, mettez entre commentaire le code de la ligne 320 à
        327 du module Game. Cet élément est uniquement visuel et son retrait 
        n'aura aucune conséquence sur le fonctionnement du jeu.


"""

from Carte import Carte
from Game import Game
from Page import Page
from Monstre import Monstre, Personnage
from Objet import Coffre, Porte, Objet
from Piece import Piece

import pygame
pygame.init()
pygame.display.set_caption("Le Sorcier de la Montagne de Feu")
screen = pygame.display.set_mode((1150,600))

game = Game()



########### CARTE 0 ###########


carte_0=Carte(game)
carte_0.ajouter_surface('herbe', (0,0, 15,9))
carte_0.ajouter_surface('mur',(0,0, 15,0))
carte_0.ajouter_surface('chemin',(7,0, 7,5))
carte_0.ajouter_surface('chemin',(5,5, 7,5))
carte_0.ajouter_surface('chemin',(5,5, 5,9))
carte_0.ajouter_surface('eau',(12,3, 13,4))
carte_0.ajouter_surface('eau',(10,2, 11,3))
carte_0.ajouter('eau',(12,5))
carte_0.ajouter_surface('eau',(11,6,12,6))
carte_0.ajouter_bordure()


page = Page(game,"La montagne se tient devant vous, menaçante. En face de vous, dans son flanc, se découpe une ouverture sombre : l'entrée de la montagne de feu, le début de votre aventure.\nSans hésitation, vous vous enfoncez dans les ténèbres.",["Partir à l'aventure !"])
page = Page(game,"Vous êtes désormais prêt à entrer dans la montagne de feu!\nUne fois l'introduction terminée, vous pourrez vous déplacer sur la carte en utilisant les flèches directionnelles de votre clavier. Et n'oubliez pas : si vous avez un doute, appuyez sur 'H' pour accéder au menu d'aide !",["Merci !"],{"Merci !":page})

page1 = Page(game,"Parfait! Vous pouvez utilisez votre potion d'adresse à tout moment en appuyant sur la touche 'P'. Vous ramasserez divers objets au cours devotre aventure, vous pouvez accéder à la liste des objets récoltés en appuyant sur la touche 'I'. Enfin, si vous avez oublié comment jouer, vous pouvez accéder au menu d'aide en appuyant sur 'H'.",["ça tombe bien, j'ai pas tout compris...","Merci mais je n'en aurai pas besoin!"],{"ça tombe bien, j'ai pas tout compris...":page,"Merci mais je n'en aurai pas besoin!":page})
page2 = Page(game,"Parfait! Vous pouvez utilisez votre potion de vigeur à tout moment en appuyant sur la touche 'P'. Vous ramasserez divers objets au cours devotre aventure, vous pouvez accéder à la liste des objets récoltés en appuyant sur la touche 'I'. Enfin, si vous avez oublié comment jouer, vous pouvez accéder au menu d'aide en appuyant sur 'H'.",["ça tombe bien, j'ai pas tout compris...","Merci mais je n'en aurai pas besoin!"],{"ça tombe bien, j'ai pas tout compris...":page,"Merci mais je n'en aurai pas besoin!":page})
page3 = Page(game,"Parfait! Vous pouvez utilisez votre potion de bonne fortune à tout moment en appuyant sur la touche 'P'. Vous ramasserez divers objets au cours devotre aventure, vous pouvez accéder à la liste des objets récoltés en appuyant sur la touche 'I'. Enfin, si vous avez oublié comment jouer, vous pouvez accéder au menu d'aide en appuyant sur 'H'.",["ça tombe bien, j'ai pas tout compris...","Merci mais je n'en aurai pas besoin!"],{"ça tombe bien, j'ai pas tout compris...":page,"Merci mais je n'en aurai pas besoin!":page})

page = Page(game,"Vos caractéristiques risquent de varier dans la montagne. Il vous propose donc une potion qui permet de retrouver vos points de départ:\n - La potion d'adresse vous rend votre habilité.\n -La potion de vigueur vous rend votre endurance.\n - La potion de bonne fortune vous rend votre chance.\n\nUtilisez les flèches de votre clavier pour séléctionner une réponse puis appuyez sur entrée :",["Potion d'adresse","Potion de vigeur","Potion de bonne fortune"],{"Potion d'adresse":page1,"Potion de vigeur":page2,"Potion de bonne fortune":page3},{"Potion d'adresse":{"choose_potion":"potion d'adresse"},"Potion de vigeur":{"choose_potion":"potion de vigueur"},"Potion de bonne fortune":{"choose_potion":"potion de bonne fortune"}})
page = Page(game,"Vous allez maintenant apprendre à faire un choix.\nTout au long de votre aventure, vous serez amené à faire des choix difficiles qui influenceront la suite de votre aventure.\n\nDans le village où vous vous êtes entraîné pendant des mois avant de venir affronter les dangers de la montagne, le chaman du village vous a proposé d'emporter avec vous une potion de sa concoction.",["(suite)"],{"(suite)":page})
page = Page(game,"Tout d'abord, les caractéristiques de l'aventurier que vous incarnez ont été tirées au sort à la création de la partie. Vous les retrouvez en haut de la carte.\n - L'habilité représente votre force et votre habilité au combat\n - L'endurance représente vos points de vie\n - Et la chance... représente votre chance naturelle !\n\nEn effet, certaines issues de l'histoire seront déterminées aléatoirement, et plus vos points de chance seront élevés, plus vous serez chanceux.",["(suite)"],{"(suite)":page})
page = Page(game,"Bienvenue, aventurier, dans 'Le Sorcier de la Montagne de Feu' !\nVous avez sûrement hâte de pénétrer dans la montagne à la recherche du trésor du sorcier, mais avant cela, passons en revue les différentes commandes et spécificités du jeu.\n\n(Appuyez sur Entrée pour continuer)",["(suite)"],{"(suite)":page})


piece = Piece(carte_0, 0,0 ,15,9, page)
carte_0.joueur.teleporter((7,2))




########### CARTE 1 ###########

carte_1=Carte(game)
carte_1.ajouter_surface('mur',(0,0, 15,9))
carte_1.ajouter('chemin',(7,9))
carte_1.ajouter_surface('chemin',(5,8,11,8))

monstre = Monstre(carte_1,5,8,'farfadet',"FARFADET",5,6,["'FARFADET' s'élance","Le farafadet vous frappe de toutes ses forces"],texte="Le passage forme un virage à droite en direction du nord.\nDans l'angle du passage, une étrange créature dort dans une guérite. Alors que vous passez devant lui, il ouvre les yeux. Pour continuer votre route, il vous faut le combattre.\n\n")





###### Piece 1
porte = Porte(carte_1,11,8,'e',resistance=True)
carte_1.ajouter_surface('vide',(12,7, 13,8))
carte_1.ajouter_surface('chemin',(1,5, 3,7))
carte_1.ajouter('chemin',(4,6))
carte_1.ajouter_surface('chemin', (1,1, 3,3))
carte_1.ajouter('chemin',(4,2))
carte_1.ajouter_surface('chemin',(5,0, 5,8))
piece = Piece(carte_1,12,6,14,9,Page(game,"La porte s'ouvre et vous tombez la tête la première dans une fosse.\n\n[ Vous perdez 2 points d'endurance ]",["Oups!"]))


###### Piece 2
porte = Porte(carte_1, 4, 6,'e',texte='Du côté ouest du passage se trouve une porte de bois brut grossièrement taillée.\nEn tendant l oreille, vous percevez une sorte de ronflement.')
monstre = Monstre(carte_1,1,5,'farfadet_2','FARFADET',6,4,["Le farfadet vous mord le bras.","Vous sentez les dents acérées du monstre s'enfoncer dans votre épaule.","Le farfadet vous met une droite. Vous ne l'aviez pas vu venir, celle-là!"],endormi=True,texte_mort="Vous sentez les crocs acérés du farfadet se planter dans votre gorge.\nQuel dommage, vous êtes mort!",texte_victoire="Vous tranchez la tête du farfadet de votre épée. Vous la voyez rouler sur le sol avant de s'immobiliser.")
coffre = Coffre(carte_1,2,6,'boite_en_bois',recompense={"cha":2,"or":1},page_ouverture=Page(game,"Vous ouvrez la boîte. A l'intérieur, vous trouvez une pièce d'or.\nVous prenez 2 points de chance.",['Ok']))
objet = Objet(carte_1,2,6,'table')

piece = Piece(carte_1,0,4,4,8,Page(game,"piece 2",["ok"]))

page1 = Page(game,"Vous vous approchez de la table en jetant un regard inquiet vers le monstre, mais, à votre grand soulagement, celui-ci ne se réveille pas.",["Ok"],fonctions={"Ok":{"deverrouiller_piece":piece}})
page2 = Page(game,"La créature se réveille en sursaut et bondit sur vous.\n\nVous pouvez prendre la fuite, mais votre adversaire\naura l'occasion de vous blesser et vous perdrez deux points d'endurance.",["Ok"],fonctions={"Ok":{"verrouiller_piece":piece}})
page = Page(game,"Vous rampez sur le sol. Il vous faut tenter votre chance :\nSi vous êtes chanceux, vous vous approchez de la table sans dommage.\nSinon, la créature se réveille.",["Tenter votre chance"],fonctions={"Tenter votre chance":{"tenter_chance":{True:page1,False:page2}}})
page = Page(game,"La porte s'ouvre sur une petite pièce dans laquelle règne une forte odeur. Au milieu se trouve une table bancale. Sur celle-ci, une petite boîte en bois est posée à même le sol.\nDans un coin, une créature semblable à celle que vous venez de terrasser dort à poingts fermés.",["Tenter de prendre la boite","Regagner le couloir"],{"Tenter de prendre la boite":page})
piece.ajouter_page(page)


###### Piece 3
porte = Porte(carte_1, 4, 2,'e')
monstre = Monstre(carte_1,1,5,'serpent','SERPENT',5,2,['Le serpent vous mord le doigt, vous secouez la main pour le faire lâcher prise, en vain'],texte_mort="Le serpent vous attaque à la gorge, vous ne parvenez pas à l'éviter.\n\nVous sentez la vie quitter lentement votre corps.",texte_victoire="Le serpent rampe lentement au sol, affaibli par votre attaque. Vous profitez de l'occasion et lui tranchez la tête de votre épée. Son corps continue de se tortiller un moment avant de retomber sur le sol, inerte.\n\nA l'intérieur de la boîte, vous trouvez une clé de bronze sur laquelle est gravé le nombre '99'.\n\n[ l'objet 'clé n°99' a été ajouté à votre inventaire ]\n\nVous gagnez 1 point de chance.",recompense={"cha":1,"inv":("clé n°99"," : Que peut bien ouvrir cette clé?")})
coffre = Coffre(carte_1,2,2,'boite_en_bois',page_ouverture=Page(game,"La boîte est légère mais quelque chose fait du bruit à l'intérieur. Vous soulevez le couvercle et un serpent en jaillit.\n\nIl vous faut le combattre.",['Engager le combat'],fonctions={"Engager le combat":{"combattre":monstre}}))
objet = Objet(carte_1,2,2,'table')
piece = Piece(carte_1,0,0,4,4,Page(game,"Vous pénetrez dans une pièce dénuée de meubles, à l'exeption d'une table rudimentaire, au centre de la pièce. Sur la table, vous apercevez une petite boîte en bois.\nVous pouvez, si vous le souhaitez, ouvrir la boîte et récupérer ce qu'elle contient.",["Ok"]))


########### CARTE 2 ###########
carte_2=Carte(game)
carte_2.ajouter_surface('mur',(0,0,15,9))
carte_2.ajouter_surface('chemin',(5,1,5,9))
carte_2.ajouter_surface('chemin',(5,1,14,1))
carte_2.ajouter('chemin',(10,0))
carte_2.ajouter_surface('chemin',(1,1,3,4))
carte_2.ajouter_surface('chemin',(1,6,3,8))
carte_2.ajouter_surface('chemin',(7,3,14,8))

###### Piece 1
porte = Porte(carte_2,4,7,'e',texte="Un peu plus loin, toujours dans le mur ouest, vous trouvez une troisième porte. Vous grimacez en entendant des voix chanter si fort et si faux que jamais vous n'auriez cru possible de parvenir à une telle cacophonie.")
carte_2.ajouter('chemin',(4,7))


monstre1 = Monstre(carte_2,2,6,'farfadet_3','FARFADET 1',5,4,["Le farfadet plante don poignard dans votre brase","Le poignard du farfadet fend l'air. Vous êtes blessé","Le farfadet se jette sur vous, vous l'évitez de justesse : sa lame vous entaille l'oreille."],particularite='ivresse',endormi=True,texte_mort="Le farfadet vous plante son poignard dans le coeur. Vous vous écroulez sur le sol.")
monstre2 = Monstre(carte_2,1,7,'farfadet_4','FARFADET 2',7,6,["Le farfadet enfonce son sabre dans votre bras.","Malgré son ivresse, le farfadet manie son sabre à la perfection. Sa lame vous entaille le flanc.","Le farfadet se jette sur vous, vous parez son attaque de votre épée mais vous êtes projetté à terre."],particularite="ivresse",endormi=True,texte_mort="Le sabre du farfadet vient se loger dans votre coeur.\nLe monstre retire son arme, l'air satisfait.")

page = Page(game, "Après avoir fini votre lecture, vous rangez le livre dans votre sac.\n\n[ l'objet 'Livre de Farrigo Di Maggio' a été ajouté à votre inventaire ]\n\nVous quittez ensuite la pièce, heureux de votre découverte.",['Ok'])
page = Page(game,"Voci les mots qu'ils te faudra prononcer\n\nQuand à combattre le dragon tu sera mené :\n\n     Ekil Erif\n     Ekam Erif\n     Erif Erif\n     Di Maggio ''",["suite"],page_suivante={"suite":page},fonctions={"suite":{"inv":("Livre de Farrigo Di Maggio"," : Il renferme le secret pour terrasser un dragon.")}})
page = Page(game,"Un message est adressé au lecteur à la fin du livre :\n\n'' A toi qui tiens entre tes mains le fruit de mes intensives recherches ,\n\nJe te confie le pouvoir que, ma vie durant, j'ai tant convoité.\n\nPuisses-tu à bien l'utiliser pour combattre le mal\n\nQui depuis l'aube des temps sévit sur le monde.",["suite"],{"suite":page})
coffre = Coffre(carte_2,2,7,'boite_en_bois',texte="Vous vous emparrez de la boîte qui se trouve sous la table.\nSur le couvercle est fixée une petite plaque de cuivre sur laquelle on peut lire :  'Farrigo Di Maggio'.\n\nVoulez-vous ouvrir la boîte?",page_ouverture=Page(game,"La boîte contient un petit livre en cuir portant le titre suivant :\n'Comment le dragon fabrique et souffle le feu'. Vous vous empressez de le lire.\n\nIl s'agit d'une oeuvre autobiographique d'un certain Di Maggio qui aurait découvert le moyen de neutraliser les dragons.",['suite'],page_suivante={'suite':page}))
objet = Objet(carte_2,2,7,'table')

piece = Piece(carte_2,0,5,4,9)
page = Page(game,"Vous entrez dans une petite pièce sale et en désordre.\nUne table se dresse au centre de la pièce. Il y a sur celle-ci une petite boîte.\nAutour de cette même table sont assis deux créatures semblables\nà celle qui dormait dans la guérite. Ils boivent une espèce de grog et à leur regard vide, vous devinez sans peine qu'ils sont ivres.",["Tirer votre épée et bondir sur eux","Sortir et courir le long du passage."],fonctions={"Tirer votre épée et bondir sur eux":{"verrouiller_piece":piece}})
piece.ajouter_page(page)

###### Piece 2
porte = Porte(carte_2,4,1,'o',texte="Le passage aboutit à une porte de bois. Vous percevez des cris de colère provenant de l'intérieur.\nAllez-vous entrer pour voir ce qu'il se passe?")
carte_2.ajouter('chemin',(4,1))


monstre2 = Monstre(carte_2,3,3,'farfadet_serviteur','SERVITEUR',5,3,["Le farfadet fait tourner son gourdin, l'air menaçant.","Le farfadet abat son gourdin. Vous êtes étourdi.","Le farfadet vous met un coup de gourdin dans les côtes. Vous avez le souffle coupé."],texte_mort="Vous recevez un coup de gourdin sur la tête. Vous entendez comme un craquement avant de perdre connaissance.\n\nVous n'y survivrez pas.",texte_victoire="Les deux farfadets sont à terre, vous vous approchez du coffre, curieux de savoir ce qu'il contient.",endormi=True)
monstre1 = Monstre(carte_2,2,3,'farfadet_chef','CHEF DES FARFADETS',8,10,["Le Chef des farfadets fait claquer son fouet.","Le fouet du farfadet vous atteint au visage. Aîe, quelle douleur cuisante!"],texte_mort="Le Chef des farfadets passe derrière vous et vous étrangle à l'aide de son fouet.\n\nVous sentez la vie vous quitter lentement.",texte_victoire="Vous avez terrassé le chef des farfadets mais son serviteur, fou de rage, se rue sur vous.",recompense={"combattre":monstre2})

page1 = Page(game,"Vous vous jetez sur les pièces d'or.\n\n[ transfert effectué avec succès ]",["Ok"])
page2 = Page(game,"Vous fourrez la bouteille dans votre sac.\n\n[ l'objet 'potion d'invisibilité' a été ajouté à votre inventaire ]",["Ok"])
page3 = Page(game,"Vous prenez le gant et le rangez dans votre sac.\n\n[ l'objet 'gant de soie noire' a été ajouté à votre inventaire ]",["Ok"])
page = Page(game,"Vous examinez avec plus d'attention le contenu du coffre.\nVous comptez les pièces d'or : il y en a 25 en tout. Vous lisez l'étiquette de la bouteille de la bouteille. Elle contient une dose de potion d'invisibilité. Le gant reste un mystère.\n\nVous ne pouvez prendre qu'une seule de ces trouvailles :",["25 pièces d'or","potion d'invisibilité","gant de soie noire"],{"25 pièces d'or":page1,"potion d'invisibilité":page2,"gant de soie noire":page3},fonctions={"25 pièces d'or":{"or":25},"potion d'invisibilité":{"inv":("potion d'invisibilité"," : elle contient une seule et unique dose.")},"gant de soie noire":{"inv":('gant de soie noie'," : vous ignorez son utilité, mais qu'est-ce qu'il est doux au toucher!")}})
page = Page(game,"Vous vous effondrez au sol. Vous retirez la flechette et pansez la blessure. Vous êtes affaibli par le combat, et cette fléchette n'arrange rien. Vous pouvez, si vous le souhaîtez, prendre un repas.",["Prendre un repas"],{"Prendre un repas":page},fonctions={"Prendre un repas":{"repas":None}})
coffre = Coffre(carte_2,2,4,'coffre_en_fer',texte = 'Le coffre est solide, fait de chêne et de fer.\nVoulez-vous essayer de briser la serrure avec votre épée?',page_ouverture=Page(game,"La serrure n'est guère solide, elle saute immédiatement et attérrit quelques mètres plus loin.\n\nIl y a un bon nombre de pièce d'or à l'intérieur. Vous y trouvez également un gant de soie noire et une petite bouteille noire munie d'un bouchon de verre.\n\nMais alors que vous admirez ce trésor, vous entendez un déclic : une fléchette empoisonnée vous atteint à l'estomac.\n\n[ Vous perdez 2 points d'endurance ]",["suite"],{"suite":page},fonctions={"suite":{'end':-2}}),verrouille=True)

piece = Piece(carte_2,0,0,3,5)


page = Page(game,"Alors que vous attaquez le Chef des farfadets, son serviteur attrape un gourdin.\nMais c'est sur VOUS qu'il bondit. Vous avez désormais deux adversaires.\n\nVous affrontez d'abord le chef des farfadets.",["Engager le combat"],fonctions={"Engager le combat":{"combattre":monstre1}})
page = Page(game,"Un coffre trône au fond de la pièce dans laquelle vous pénetrez. Dans un coin se trouve le chef des farfadets, que vous reconnaissez à son accoutrement. Un fouet à la main, il est occupé à corriger son serviteur qui gémit sous les coups.",["Attaquer le chef","Les attaquer tous les deux","Quitter la pièce"],page_suivante={"Les attaquer tous les deux":page},fonctions={"Attaquer le chef":{"verrouiller_piece":piece,"combattre":monstre1},"Les attaquer tous les deux":{"verrouiller_piece":piece}})
piece.ajouter_page(page)


###### Piece 3
porte = Porte(carte_2,13,2,'n',"Vous arrivez à une massive porte de bois. Vous entendez des marmonnements et des bruits de marmites et de casseroles qui s'entrechoquent.")
carte_2.ajouter('chemin',(13,2))


objet = Objet(carte_2,7,3,"commode")
objet = Objet(carte_2,8,3,"evier")
objet = Objet(carte_2,9,3,"evier")
objet = Objet(carte_2,11,8,"tonneau")
objet = Objet(carte_2,10,8,"pot_couvert")
objet = Objet(carte_2,9,8,"pot_couvert")
objet = Objet(carte_2,8,8,"pot")
objet = Objet(carte_2,7,8,"pot_couvert")
objet = Objet(carte_2,9,5,"table")
objet = Objet(carte_2,9,5,"assiette_vide")
objet = Objet(carte_2,10,5,"table")
objet = Objet(carte_2,10,5,"assiette_pleine")
objet = Objet(carte_2,11,5,"table")
objet = Objet(carte_2,11,5,"marmitte")
objet = Objet(carte_2,12,5,"table")
objet = Objet(carte_2,12,5,"assiette_vide")


monstre1 = Monstre(carte_2,9,6,'farfadet_5','FARFADET 1',8,6,["Le farfadet fait tourner son rouleau à patisserie, l'air menaçant.","Le farfadet vous malmène comme une pâte à pain."],texte_mort="Vous ne savez pas bien comment, mais ce rouleau à patisserie a eu raison de vous.\n\nQuelle défaite cuisante!",endormi=True)
monstre2 = Monstre(carte_2,10,6,'farfadet_6','FARFADET 2',8,5,["Vous louchez sur la louche de votre adversaire. Ce mauvais jeu de mots vous destabilise et vous ne voyez pas venir son attaque.","Le farfadet vous attaque avec une louche. Vous trouvez ça louche... et douloureux."],texte_mort="Le farfadet abat sa louche de toutes ses forces.Vous tombez à terre, hébété. Les autres farfadets vous achèvent.",endormi=True)
monstre3 = Monstre(carte_2,11,6,'farfadet_7','FARFADET 3',9,6,["Le farfadet vous lance des os de rats à la figure.","Le farfadet vous lance des petites cuillères."],texte_mort="Le farfadet vous achève à coups de marmite.",endormi=True)
monstre4 = Monstre(carte_2,12,6,'farfadet_8','FARFADET 4',7,4,["Le farfadet vous frappe de sa spatule.","Vous recevez un grand coup de spatule sur la tête.","Le farfadet abat sa spatule sur vous sans pitié."],texte_mort="Le farfadet parvient à vous assener un coup de spatule à l'arrière de la tête. Vous baslculez en avant, étourdi, et vous tombez la tête la première.\n\nLes autres farfadets vous achèvent.",endormi=True)

page=Page(game,"Vous découvrez un arc magnifique accompagnée d'une flèche d'argent. Sur le manche de l'arc vous pouvez lire : \n\n'Celui qui donne le sommeil à ceux qui ne peuvent dormir...'\n\nVous l'emportez avec vous.\n\n[ l'objet 'Arc et flèche d'argent' a été ajouté à votre inventaire ]\n\nVous gagnez un point de chance pour cette découverte.",["Ok"])
coffre = Coffre(carte_2,12,8,"coffre_en_bois",page_ouverture=page,recompense={"cha":1,"inv":("Arc et flèche d'argent"," : 'Celui qui donne le sommeil à ceux qui ne peuvent dormir...'")})

piece = Piece(carte_2,6,2,15,9)

page1 = Page(game,"Vous sortez de la pièce à pas de loup.",["Ok"])
page2 = Page(game,"En tentant de fuir, vous marchez sur un os de rat. Les farfadets se retournent vers vous.\n\nIl vous faut les combattre.",["Ok"],fonctions={"Ok":{"verrouiller_piece":piece}})
page = Page(game, "Ils sont si absorbés par leur dispute pour savoir qui pourra ronger les os au fond de la marmite qu'ils ne vous ont pas vu. Vous pouvez en profitez pour les attaquer par surprise mais si vous trouvez totalement stupide de vous attaquer à une horde d'adversaires redoutables sans raison, vous pouvez tenter votre chance pour fuir sans vous faire remarquer.",["Les attaquer","Tenter votre chance"],fonctions={"Les attaquer":{"verrouiller_piece":piece},"Tenter votre chance":{"tenter_chance":{True:page1,False:page2}}})
page = Page(game,"Vous ouvrez la porte et découvrez une vaste pièce meublée\nd'une grande table et de meubles de cuisine. Vous ouvrez la porte et découvrez une vaste pièce meublée d'une grande table et de meubles de cuisine.\n\nIl s'agit de la salle à manger des farfadets. Quatre de ces créatures sont attablées et dégustent une soupe de gésiers de rats.",["suite"],{"suite":page})

piece.ajouter_page(page)


########### CARTE 3 ###########
carte_3=Carte(game)
carte_3.ajouter_surface('mur',(0,0,15,9))
carte_3.ajouter_surface('chemin',(10,0,10,9))
carte_3.ajouter_surface('chemin',(1,0,1,3),camoufle=True)
carte_3.ajouter_surface('chemin',(0,3,0,5),camoufle=True)
carte_3.ajouter_surface('chemin',(1,5,1,8),camoufle=True)
carte_3.ajouter('chemin',(2,8),camoufle=True)
carte_3.ajouter_surface('chemin',(3,1,3,8),camoufle=True)
carte_3.ajouter('chemin',(4,1),camoufle=True)
carte_3.ajouter_surface('chemin',(5,1,5,4),camoufle=True)
carte_3.ajouter_surface('chemin',(6,4,6,5),camoufle=True)
carte_3.ajouter_surface('herbe',(12,5,14,8))
carte_3.ajouter_surface('chemin',(12,1,14,3))
carte_3.ajouter_surface('chemin',(5,6,7,8))




###### Piece 1
porte = Porte(carte_3, 11,7,'o',texte="En progressant vers le nord dans ce nouveau couloir, vous passez devant une porte sur votre droite. Vous entendez un homme appeler à l'aide.",resistance=True)
carte_3.ajouter('chemin',(11,7))

viel_homme = Personnage(carte_3,12,7,'viel_homme','attaque')

page = Page(game,"Vous vous dites alors au revoir et repartez chacun de votre côtés.\n\nVous vous souviendrez longtemps de cette rencontre émouvante et des précieux conseils que le viel homme vous a donné.",["Ok"],fonctions={"Ok":{"changer_etat":(viel_homme,"parti")}})
page = Page(game,"Vous lui demandez alors s'il a appris des choses qui pourraient vous aider dans votre périple durant sa captivité. Il vous recommande de vous montrer respectueux avec le passeur. Il sait aussi que les clés du hangar à bateaux sont gardées par un homme et son chien.",["suite"],{"suite":page},{"suite":{"changer_etat":(viel_homme,"dit_au_revoir")}})
page = Page(game,"Il y a de nombreuses années, il était, tout comme vous, parti à l'aventure à la recherche du trésor du sorcier. Les farfadets l'avaient alors capturé et jeté dans cette cellule. Il était devenu une sorte d'humain de compagnie et n'avait plus vu la lumière du jour depuis. Vous lui demandez s'il souhaite vous accompagner dans votre quête, mais il n'a qu'un seul désir : revoir le monde extérieur.",["suite"],{"suite":page})
page1 = Page(game,"Vous prenez une grande inspiration avant de crier :\n'Te voilà libre, vieillard!'. Il cesse aussitôt ses hurlements et s'effondre sur le sol en pleurant à gros sanglots.\n\nPuis, petit à petit, il se reprend et vous remercie chaleureusement. Vous bavardez avec lui et il commence à vous raconter son histoire.",["suite"],{"suite":page},fonctions={"suite":{"changer_etat":(viel_homme,"parle")}})
page2 = Page(game,"Alors que le viellard bondit sur vous, vous lui passer votre épée au travers de la poitrine. Mais vous réalisez aussitôt que le vieillard ne cherchait pas à vous attaquer. Son excitation était simplement due au soulagement qu'il éprouvait d'être enfin libéré. Vous ne pouvez plus maintenant lui poser de questions sur les périls qui vous attendent.\n\nVous retournez dans le couloir en vous maudissant d'avoir agi ainsi.",["Ok"])
piece = Piece(carte_3,11,4,15,9,Page(game,"Vous enfoncez la porte qui s'ouvre à la volée. Une puanteur immonde vous monte immédiatement aux narines. Vous vous apercevez avec dégout que le plancher est recouvert de vase, d'os et de végétaux en décomposition. Un viel homme aux cheveux ébouriffés, vêtu de haillons, se rue sur vous en hurlant, un vieux pied de chaise à la main.",["Crier pour tenter de le calmer","Tirer votre épée et l'attaquer"],{"Crier pour tenter de le calmer":page1,"Tirer votre épée et l'attaquer":page2},fonctions={"Crier pour tenter de le calmer":{"changer_etat":(viel_homme,"pleure")},"Tirer votre épée et l'attaquer":{"changer_etat":(viel_homme,"parti")}}))


###### Piece 2
porte = Porte(carte_3, 11,3,'o',"Un peu plus loin, vous découvrez une autre porte, toujours dans le mur est du passage.",resistance=True)
carte_3.ajouter('chemin',(11,3))

objet = Objet(carte_3,12,1,"rangement_epees")

objet = Objet(carte_3,13,0,"sabre_au_mur")
objet = Objet(carte_3,14,1,"rangement_lances")
coffre = Coffre(carte_3,13,1,"coffre_en_fer",recompense={"retirer_inv":"bouclier","inv":("bouclier de lune"," : 17% de chance de ne perdre qu'un point à chaque dégât pris.")},page_ouverture=Page(game,"Vous découvrez émerveillé un bouclier rond sur lequel est gravé un croissant de lune. Ce bouclier de haute facture vous aidera à détourner les attaques de vos ennemis. Vous décidez d'abandonner votre ancien bouclier et le remplacez par votre trouvaille.\n\n[ l'objet 'bouclier' a été retiré de votre inventaire ]\n\n[ l'objet 'bouclier de lune' a été ajouté à votre inventaire ]",["Ok"]))

piece = Piece(carte_3,11,0,15,4,Page(game,"Vous parvenez à casser le panneau de bois et à entrer. Une torche fixée à l'un des murs éclaire une petite salle d'armes remplie d'épées, de boucliers, de poignards et d'autres armes en tout genre...\n\nAlors que vous explorer la pièce, un coffre attire votre regard.",["Ok"]))




###### Piece secrète

cofre = Coffre(carte_3,6,7,"coffre_en_or")
piece = Piece(carte_3,4,5,8,9,Page(game,"Vous pénétrez dans une pièce secrète.",["Ok"]))




########### CARTE 4 ###########
carte_4=Carte(game)
carte_4.ajouter_surface('mur',(0,0,15,9))
carte_4.ajouter_surface('chemin',(10,0,10,9))
carte_4.ajouter_surface('chemin',(7,1,9,1),camoufle=True)
carte_4.ajouter_surface('chemin',(5,2,7,2),camoufle=True)
carte_4.ajouter_surface('chemin',(1,1,5,1),camoufle=True)
carte_4.ajouter_surface('chemin',(1,1,1,3),camoufle=True)
carte_4.ajouter_surface('chemin',(1,3,3,3),camoufle=True)
carte_4.ajouter_surface('chemin',(3,4,6,4),camoufle=True)
carte_4.ajouter('chemin',(6,5),camoufle=True)
carte_4.ajouter_surface('chemin',(5,6,6,6),camoufle=True)
carte_4.ajouter_surface('chemin',(1,7,5,7),camoufle=True)
carte_4.ajouter_surface('chemin',(1,8,1,9),camoufle=True)
carte_4.ajouter_surface('chemin',(12,5,14,8))



###### Piece 1
porte = Porte(carte_4, 11,7,'o',"Vous arrivez à une autre porte sur votre droite.\n\nAlors que vous vous approchez, un hurlement déchire le silence : Une séance de torture a lieu en ce moment même.")
carte_4.ajouter('chemin',(11,7))

objet = Objet(carte_4,12,5,"rangement_lances")
objet = Objet(carte_4,13,5,"rangement_epees")

monstre1 = Monstre(carte_4,12,6,"lutin_1",'LUTIN 1',8,10,["Le lutin vous attaque.","Flûte! Le lutin lutte et ne se loupe pas!"])
monstre2 = Monstre(carte_4,13,6,"lutin_2",'LUTIN 2',9,10,["Le lutin vous attaque.","Flûte! Le lutin lutte et ne se loupe pas!"],recompense={"inv":("morceau de fromage"," : son odeur alléchante vous donne l'eau à la bouche.")},texte_victoire="Vous fouillez les poches du lutin et trouvez un morceau de fromage.\n\n[ l'objet 'morceau de fromage' a été ajouté à votre inventaire ]")
nain = Personnage(carte_4,14,6,"nain",etat="mort")

page = Page(game,"Vous ne trouvez rien d'intéressant dans la pièce, sauf, bien sûr, si les instruments de torture constituent pour vous une source d'amusement, auquel cas, NOUS NE VOUS AUTORISONS PAS A\nRECUPERER UN DE SES OBJETS\ncar nous jugeons que de telles pensées ne siéent guère à un héros de livre d'aventure.",["Ok"])
page = Page(game,"Nous ne vous demanderons pas quelle idée saugrenue vous est passée par la tête. Nous esperons simplement pour votre santé mentale et la sécurité de votre entourage que vous aviez remarqué que le nain était mort et qu'il s'agissait là d'une ruse. Si c'en était une, elle a fonctionné puisque les lutins, après avoir échangé un regard stupéfait, arborent un grand sourire et partent chercher\nun autre nain pour que vous puissiez continuer à vous amuser tous les trois.",["suite"],{"suite":page},{"suite":{"tuer":(monstre1,monstre2)}})
page = Page(game,"La porte s'ouvre sur une pièce de torture. Au centre de la pièce, deux petites créatures bossues exercent leur ignoble besogne sur un nain attaché par les poignets à un crochet fixé au plafond. Le nain pousse un dernier cri puis se tait, les yeux fermés. Ses géôliers émettent des exclamations de dépit et se tournent vers vous avec colère, comme si vous étiez responsable de son évanouissement.",["Refermer la porte et poursuivre votre chemin","Tirer votre épée et combattre les deux créatures","Blesser le nain pour donner le change aux tortionnaires"],{"Blesser le nain pour donner le change aux tortionnaires":page},fonctions={"Tirer votre épée et combattre les deux créatures":{"verrouiller_piece":piece}})
piece = Piece(carte_4,11,4,15,9,page)

###### fin
piece = Piece(carte_4,10,0,10,0,Page(game,"Félicitation !\nVous avez terminé la première partie du 'Sorcier de la Montagne de Feu', écrit par Steve Jackson et Ian Livingstone!\n\nPour connaitre la suite du périple de notre héros intrépide, achetez la version originale papier du 'Sorcier de la Montagne de Feu' : munissez-vous de deux dés, d'une gomme et d'un crayon de papier et partez à l'aventure à la recherche du trésor du sorcier !",["Je cours acheter le 'Soricer de la Montagne de Feu' !"],fonctions={"Je cours acheter le 'Soricer de la Montagne de Feu' !":{"exit":None}}))


#### ENREGISTRER LES CARTES ####

carte_0.ajouter_carte_n(1)
carte_1.ajouter_carte_s(0)
carte_1.ajouter_carte_n(2)
carte_2.ajouter_carte_s(1)
carte_2.ajouter_carte_n(3)
carte_3.ajouter_carte_s(2)
carte_3.ajouter_carte_n(4)
carte_4.ajouter_carte_s(3)


game.ajouter_carte(carte_0)
game.ajouter_carte(carte_1)
game.ajouter_carte(carte_2)
game.ajouter_carte(carte_3)
game.ajouter_carte(carte_4)

print(game)



while game.running:

    screen.fill((0,0,0))
    game.update(screen)

    pygame.display.flip()

    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            game.running = False
            pygame.quit()


        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_h:
                game.aide()
            elif event.key == pygame.K_p:
                game.potion()
            elif event.key == pygame.K_i:
                game.inventaire()

            elif event.key == pygame.K_UP or event.key == pygame.K_LEFT:
                game.choix_haut()
            elif event.key == pygame.K_DOWN or event.key == pygame.K_RIGHT:
                game.choix_bas()
            elif event.key== pygame.K_RETURN:
                game.valider_choix()
            game.touches_enfoncees[event.key] = True
            


        elif event.type == pygame.KEYUP:
            game.touches_enfoncees[event.key] = False


