# TAD Pile

class Pile:
    # constructeurs
    def __init__(self):
        self.__items = []

    # accesseurs

    @property  # built-in decorator permet de protéger l'attribut
    def items(self):
        assert (False), "Encapsulation de la donnée, utiliser la méthode dernier"

    @items.setter
    def items(self):
        assert (False), "Encapsulation de la donnée, utiliser la méthode empiler ou depiler"

    # sommet : Pile[T] → T
    def dernier(self):
        assert (not self.estVide()), "Pile vide, dernier non existant"
        return self.__items[0]

    # modificateurs

    # empiler : Pile[T] x T → Pile[T]
    def empiler(self, val):
        self.__items.insert(0, val) # plus simple d'ajouter en tête

    # depiler : Pile[T] → Pile[T]
    def depiler(self):
        assert(not self.estVide()), "Pile vide, impossible de dépiler"
        self.__items.pop(0)  # on enlève le dernier ajouté

    # accesseurs

    # estVide : Pile[T] → Booléen
    def estVide(self):
        return len(self.__items) == 0

    # version récursive
    def __eq__(self, pile):
        if (len(self.__items) == 0 and len(pile.__items) == 0):
            return True
        if (len(self.__items) !=  len(pile.__items)):
            return False
        return self.depiler() == pile.depiler()

    # different : Pile[T] x Pile[T] → Booléen (facultatif)
    def __ne__(self, pile):
        return not (self == pile)

    def __str__(self):
        return str(self.__items)

    # donne le schéma de construction de l'instance
    def __repr__(self):
        return "Pile()"