from Pile import *
import time

def set_parameters(new_time=None, new_date=None):
    if new_time != None:
        global global_time
        global_time = new_time
    if new_date != None:
        global global_date
        global_date = new_date

def gap(size = 50):
    for _ in range(size):
        print("")

class House():
    def __init__(self, location):
        self.location = location
        self.people_inside = []
    def __append_person(self, person):
        self.poeple_inside.append(person)
    def __remove_person(self, person):
        self.poeple_inside.remove(person)

class Room():
    def __init__(self, house, name):
        self.house = house
        self.name = name

class Person():
    def __init__(self, first_name, last_name, sexe, birth_date, house = None):
        self.first_name = first_name
        self.last_name = last_name
        self.sexe = sexe
        self.birth_date = birth_date
        self.phone = None
        self.house = house

    def __str__(self):
        return "{} {} est un(e) {} et est né(e) le {}".format(self.first_name, self.last_name, self.sexe, self.birth_date)

    def __repr__(self):
        return "Person({}, {}, {}, {})".format(self.first_name, self.last_name, self.sexe, self.birth_date)

    def think(self, thought="..."):
        print("[{}] ({})".format(self.first_name,thought))

    def speak(self, words):
        print("[{}] \"{}\"".format(self.first_name,words))

    def sound(self, sound):
        print("[{}] *{}*".format(self.first_name, sound))

    def do(self, act):
        print("[{}] **{}**".format(self.first_name, act))

    def take_phone(self, phone):
        assert self.phone == None
        self.phone = phone
        self.do("prend son téléphone")

    def pose_phone(self):
        assert self.phone != None
        self.phone = None
        self.do("pose son téléphone")

    def watch_phone(self, phone = None, y = 0):
        assert self.phone != None
        if phone == None:
            self.phone.update_message_tab()
        else:
            self.phone.update_message(phone, y=y)
        self.phone.print_display()

    def enter_house(self, house):
        assert self.house == None
        self.do("rentre dans maison")
        self.house = house

    def exit_house(self):
        assert self.house != None
        self.do("sort de la maison")
        self.house = None

    def enter_room(self, room):
        self.do("entre dans {}".format(room.name))
        self.exit_room()
        self.room = room

    def exit_room(self):
        assert self.room != None
        self.room = None

    def walk_to(self, point, duration):
        for s in range(duration):
            print("{} marche jusqu'à {}".format(self.first_name, point))
            print("#"*int(s/duration*10)+"-"*int(10-s/duration*10))
            time.sleep(1)
        print("{} est arrivé à {}".format(self.first_name, point))
        print("#"*10)


class Device():
    def __init__(self, name):
        self.name = name

    def say(self, sentence):
        print("{} \"{}\"".format(self.name, sentence))

    def sound(self, sound):
        print("{} *{}*".format(self.name, sound))

class Phone(Device):
    def __init__(self, brand, model, owner, ip):
        super().__init__("Telephone")
        self.brand = brand
        self.model = model
        self.owner = owner
        self.ip = ip
        self.battery = 100
        self.network = ("Wifi", 3)
        self.messages = Pile()

    def __str__(self):
        return "Ce téléphone est un {} {}. I appartient à {} {}".format(self.brand, self.model, self.owner.first_name, self.owner.last_name)

    def __repr__(self):
        return "Phone({}, {}, {})".format(self.brand, self.model, self.owner.__repr__())

    def __eq__(self, other):
        if type(other) == Phone:
            return self.ip == other.ip
        return False

    ###
    ### FORMATE
    ###
    def __format_text(self, value, place_holder):
        return place_holder[:(len(place_holder)-len(str(value)))]+str(value)

    ###
    ### AFFICHE
    ###
    def print_display(self):
        ###
        ### AFFICHE HAUT
        ###
        if self.battery <= 15:
            battery_icon = "[!]"
        else:
            battery_icon = "[]"
        network_icon = "▮"*self.network[1] + "▯"*(4-self.network[1])
        self.top_display = [
            "|{}|".format("-"*41),
            "| {}/{} {}:{} {} |".format(
                self.__format_text(global_date[0], "00"),
                self.__format_text(global_date[1], "00"),
                self.__format_text(global_time[0], "00"),
                self.__format_text(global_time[1], "00"),
                self.__format_text(self.network[0] + network_icon + " " + self.__format_text(self.battery, "   ")+"%"+battery_icon," "*27)),
            "|{}|".format("-"*41)]

        ###
        ### AFFICHAGE BAS
        ###
        self.bottom_display = ["|"+"-"*41+"|", "|     |||=|||     |||^|||     |||<|||     |","|"+"-"*41+"|"]

        ###
        ### AFFICHAGE
        ###
        print("")
        for line in self.top_display + self.center_display + self.bottom_display:
            print(line)
        print("")

    ###
    ### CHANGER BETTERY
    ###
    def update_battery(self, battery_amount):
        self.battery = battery_amount

    ###
    ### CHANGER CONNECTION
    ###
    def update_network(self, network_name, network_amount):
        self.network = (network_name, network_amount)

    ###
    ### NOUVEAU MESSAGE
    ###
    def __new_message(self, phone, from_me, message, date = None, time = None):
        ###
        ### CHERCHER
        ###
        temp_pile = Pile()
        while not (self.messages.estVide() or self.messages.dernier()[0] == phone):
            temp_pile.empiler(self.messages.dernier())
            self.messages.depiler()

        ###
        ### SI PAS DE CONTACT
        ###
        if self.messages.estVide():
            while not temp_pile.estVide():
                self.messages.empiler(temp_pile.dernier())
                temp_pile.depiler()
            self.messages.empiler((phone, phone.owner.first_name, 1, [(from_me, message, date, time)]))

        ###
        ### SI CONTACT
        ###
        else:
            temp = self.messages.dernier()
            self.messages.depiler()
            temp[3].append((from_me, message, date, time))
            while not temp_pile.estVide():
                self.messages.empiler(temp_pile.dernier())
                temp_pile.depiler()
            self.messages.empiler((temp[0], temp[1], temp[2]+1, temp[3]))

    ###
    ### RENOME LOCALEMENT UN CONTACT
    ###
    def rename(self, phone, name):
        temp_pile = Pile()
        while not self.messages.dernier()[0] == phone:
            temp_pile.empiler(self.messages.dernier())
            self.messages.depiler()
        temp = self.messages.dernier()
        self.messages.depiler()
        self.messages.empiler((temp[0], name, temp[2], temp[3]))
        while not temp_pile.estVide():
            self.messages.empiler(temp_pile.dernier())
            temp_pile.depiler()

    ###
    ### ENVOIE MESAGE A AUTRE PHONE()
    ###
    def send_message(self, phone, message, date = None, time = None):
        if self.network[1] > 0:
            if date == None:
                date = global_date
            if time == None:
                time = global_time
            self.__new_message(phone, True, message, date, time)
            self.open_message(phone)
            phone.__new_message(self, False, message, date, time)


    ###
    ### ACTUALISE L'AFFICHAGE DE L'ONGLET "MESSAGE"
    ###
    def update_message_tab(self, y=0):
        message_tab_display = []
        temp_pile = Pile()

        ###
        ### POUR CHAQUE CONTACT
        ###
        while not self.messages.estVide():
            name,news,msg_list = self.messages.dernier()[1:]

            ###
            ### FORMATER NOM
            ###
            if len(name) > 12:
                name = name[:11] + "."            # [0:11[ +1 = 12
            else:
                name = name + " "*(12-len(name))  # x + 12-x = 12

            ###
            ### FORMATER NOUVELLES NOTIFS
            ###
            if news > 0:
                if news > 99:
                    news = "(99+)"
                else:
                    news = "{}({})".format(" "*(3-len(str(news))),news)
            else:
                news = "     "

            ###
            ### AFFICHAGE DE CHAQUE CONTACT
            ###
            message_tab_display.append("| |{}| |".format("-"*37))
            message_tab_display.append("| | {}    {}   {}/{} {}:{} | |".format(
                name,
                news,
                self.__format_text(msg_list[-1][2][0], "00"),
                self.__format_text(msg_list[-1][2][1], "00"),
                self.__format_text(msg_list[-1][3][0], "00"),
                self.__format_text(msg_list[-1][3][1], "00")))
            message_tab_display.append("| |{}| |".format("-"*37))
            message_tab_display.append("|{}|".format(" "*41))

            temp_pile.empiler(self.messages.dernier())
            self.messages.depiler()
        while not temp_pile.estVide():
            self.messages.empiler(temp_pile.dernier())
            temp_pile.depiler()

        ###
        ### AFFICHAGE
        ###
        if len(message_tab_display) > 29:
            message_tab_display = message_tab_display[y:30+y] # UPDATE : [i:31+i]
        else:
            message_tab_display = message_tab_display + ["|{}|".format(" "*41)]*(30-len(message_tab_display))

        self.center_display = ["| Messages:{}|".format(" "*31),"|{}|".format(" "*41)] + message_tab_display

    ###
    ### MET NOMBRE DE NOUVELLES NOTIFS A 0
    ###
    def open_message(self,phone):
        temp_pile = Pile()
        while not self.messages.dernier()[0] == phone:
            temp_pile.empiler(self.messages.dernier())
            self.messages.depiler()
        temp = self.messages.dernier()
        self.messages.depiler()
        self.messages.empiler((temp[0],temp[1],0,temp[3]))
        while not temp_pile.estVide():
            self.messages.empiler(temp_pile.dernier())
            temp_pile.depiler()

    ###
    ### ACTUALISE L'AFFICHAGE D'UN CONTACT
    ###
    def update_message(self, phone, y=0):
        self.open_message(phone)
        message_display = []

        ###
        ### RETROUVER DESTINATAIRE ET LISTE DES MESSAGES
        ###
        temp_pile = Pile()
        while not self.messages.dernier()[0] == phone:
            temp_pile.empiler(self.messages.dernier())
            self.messages.depiler()
        name = self.messages.dernier()[1]
        msg_list = self.messages.dernier()[3]
        while not temp_pile.estVide():
            self.messages.empiler(temp_pile.dernier())
            temp_pile.depiler()

        ###
        ### FORMATER NOM
        ###
        if len(name) > 20:
            name = name[:19] + ". :"            # [0:11[ +1 = 12
        else:
            name = name + " :"  # x + 12-x = 12

        ###
        ### AJOUTER AFFICHAGE DE CHAQUE MESSAGE
        ###

        for i in range(len(msg_list)):
            msg = msg_list[i]

            ###
            ### DATE
            ###

                ### Formater date
            date = msg[2]
            date = "|{}/{}|".format(" "*18+
                self.__format_text(date[0], "00"),
                self.__format_text(date[1], "00")+" "*18)

                ### Ajouter date si 1er message ou date différente
            if i == 0:
                message_display.append(date)
            elif msg_list[i-1][2] != msg[2]:
                message_display.append(date)

            ###
            ### MESSAGE
            ###

                ### Formater message
            text = msg[1]
            line_list = []
            while len(text) > 35:
                line = text[:35]
                for n in range(35):
                    if text[35-n] == " ":
                        break
                line_list.append(line[:35-n])
                text = text[36-n:]
            line_list.append(text)

                ### Ajouter chaque morceau de message
            for line in line_list:
                message_display.append("|{}{}{}|".format(
                    " "*(39-len(line))*msg[0] + " "*2*(not msg[0]),
                    line,
                    " "*(39-len(line))*(not msg[0]) + " "*2*msg[0]
                    ))

            ###
            ### HEURE
            ###

                ### Ajouter heure si
            if i == len(msg_list)-1 or msg[0] != msg_list[i+1][0] or msg[2] != msg_list[i+1][2] or msg[3] != msg_list[i+1][3]:
                message_display.append("|{}{}:{}{}|".format(
                    " "*35*msg[0]+" "*(not msg[0]),
                    self.__format_text(msg[3][0], "00"),
                    self.__format_text(msg[3][1], "00"),
                    " "*35*(not msg[0])+" "*msg[0]
                    ))
                if i != len(msg_list)-1:
                    message_display.append("|{}|".format(" "*41))

            ###
            ### DATE (si dernier message)
            ###

                ### Formater date
            date = global_date
            date = "|{}/{}|".format(" "*18+
                self.__format_text(date[0], "00"),
                self.__format_text(date[1], "00")+" "*18)

                ### Ajouter date si
            if i == len(msg_list)-1 and msg[2] != global_date:
                message_display.append(date)

        ###
        ### AFFICHAGE
        ###

        if len(message_display) > 29:
            message_display = message_display[-30-y:len(message_display)-y]
        else:
            message_display = message_display + ["|{}|".format(" "*41)]*(30-len(message_display))

        self.center_display = ["| {}{}|".format(name," "*(40-len(name))),"|{}|".format(" "*41)] + message_display

####################################################################################

set_parameters(new_date=(4,11), new_time=(11,0))
### Structure de la maison #########################
house = House("RedLake")                           #
cain_bedroom = Room(house,"Chambre de Cain")       #
parent_bedroom = Room(house,"Chambre des parents") #
kitchen = Room(house,"Cuisine")                    #
living_room = Room(house,"Sale à manger")          #
dining_room = Room(house,"Salon")                  #
bath_room = Room(house,"Salle de bain")            #
####################################################

    # Assistant
a_g = Person("Assistant", "-", "binaire", "04/09/1998")

    # Cain (Personage principal)
cain = Person("Cain","Allen","Homme","06/05/2004")
cain_phone = Phone("Samsung", "S8", cain, "ip_cain")
cain.phone = cain_phone
cain.house = house
house.people_inside.append(cain)
cain.room = cain_bedroom

    # Anna (Maman)
anna = Person("Anna","Allen","Femme","-")
anna_phone = Phone("Wiko", "Y62", anna, "ip_anna")
anna.phone = anna_phone

    # Paul (Papa)
paul = Person("Paul","-","Homme","-")
paul_phone = Phone("IPhone", "13", paul, "ip_paul")
paul.phone = paul_phone

    # Georgette (Mamie)
georgette = Person("Georgette","Allen","Femme","-")
georgette_phone = Phone("Wiko", "Y51", georgette, "ip_georgette")
georgette.phone = georgette_phone

    # Ryan (Ami)
ryan = Person("Ryan","Hoover","Homme","-")
ryan_phone = Phone("IPhone", "10", ryan, "ip_ryan")
ryan.phone = ryan_phone

## Anciens messages
    # Paul
paul.phone.send_message(cain_phone, "Je part chercher tu lait surtout t'inquètes je reviens hein", (25,12), (23,42))
cain.phone.send_message(paul_phone, "Ok", (25,12), (23,43))
    # Georgette
cain.phone.send_message(georgette_phone, "Bon anniversaire mamie", (23,10), (10,29))
    # Anna
anna.phone.send_message(cain_phone, "J'arrive bienttôt à la garre, je te tiens au courant de la suite", (3,11), (12,8))
anna.phone.send_message(cain_phone, "Je vais monter dans l'avion là, je te réponds après", (3,11), (12,10))
cain.phone.send_message(anna_phone, "Ok", (3,11), (12,13))
anna.phone.send_message(cain_phone, "Ok du coup je suis arrivé", (3,11), (19,26))
cain.phone.send_message(anna_phone, "Tu arrive chez Paul quand ?", (3,11), (19,49))
anna.phone.send_message(cain_phone, "D'ici une heure je pense, il y a beaucoup plus de bouchons que prévu", (3,11), (20,10))
anna.phone.send_message(cain_phone, "Mais t'es fait pas ça ira, je reviens bientôt, bisous, bonne nuit", (3,11), (20,11))
cain.phone.send_message(anna_phone, "Ok, bonne nuit", (3,11), (21,24))
    # Ryan
ryan.phone.send_message(cain_phone, "Ouais, c'etait cool" ,(1,11), (11,15))
cain.phone.send_message(ryan_phone, "Ma mère est partie pour le week-end..." ,(3,11), (18,47))
cain.phone.send_message(ryan_phone, "Ca te dirais qu'on se fasse une aprem ensemble ?" ,(3,11), (18,48))
ryan.phone.send_message(cain_phone, "Je suis désoler" ,(3,11), (19,25))
ryan.phone.send_message(cain_phone, "Je serais pas là" ,(3,11), (19,25))
cain.phone.send_message(ryan_phone, "Bon, Ok tant pis" ,(3,11), (23,11))
cain.phone.send_message(ryan_phone, "A demain alors" ,(3,11), (23,11))
ryan.phone.send_message(cain_phone, "Je suis désoler, demain je pourrais pas trop parler demain, je part chez des amis " ,(3,11), (23,41))

# Changer noms
cain_phone.rename(anna_phone, "Maman")
cain_phone.rename(georgette_phone, "Mamie")

cain.phone = None

##-------------------------
## 1 Introduction
##-------------------------

#
# 1.1 Rêve
#

a_g.speak("Bonjour, pour continuer, merci d'appyuer sur [ENTRER].")
time.sleep(1)
a_g.speak("Detection d'input en cours...")

input()
a_g.speak("Input detecté avec succès.")

input()
a_g.speak("Calibrage en cours...")

input()
for line in ["|{}|".format("-"*43)]+["|{}|".format(" "*43)]*39+["|{}|".format("-"*43)]:
    print(line)
a_g.speak("Pour poursuivre le calibrage, assurez vous que l'intégralité du cadre ci-dessus rentre dans l'affichage de la console.")
a_g.speak("Si ce n'est pas le cas, vous pouvez détacher l'affichage de la console (Options[≡] > Undock[↗]).")
a_g.speak("Une fois le calibrage terminé, merci d'appyuer sur [ENTRER].")

input()
a_g.speak("Calibrage exécuté avec succès")

input()
a_g.speak("Autodestruction en cours...")

input()
cain.speak("Comment ça autodestruction ?")

input()
for _ in range(4):
    a_g.speak("Autodestruction dans {}".format(5-_))
    time.sleep(1)
    cain.speak(["Quoi !?", "Mais non attends !", "Mais qu'es ce que tu fait ?!", "NON Attends ne fait pas ça !", "NON MAIS STOP STOP STOP !!"][_])
    time.sleep(1)

alarm_clock = Device("???")

for _ in range(3):
    alarm_clock.sound("bip")
    time.sleep(1)

for _ in ["Wow, qu'es ce qui ce passe ? Et je suis où là ? Pourquoi il fait tout noir ??",
          "C'est quoi ce bruit ? Et ça viens d'où ?",
          "Au SECOURS, Y'A QUElQU'UN ??"]:
    input()
    cain.speak(_)

    input()
    alarm_clock.sound("bip")

#
# 1.2 Reveil
#

input()
cain.do("éteint le reveil")
time.sleep(2)
cain.think("Ok, pas de panique j'a juste fait un cauchemard...")

input()
cain_phone.update_battery(99)
set_parameters(new_time=(11,5))
cain.take_phone(cain_phone)

input()
print("Telephone verouillé")
print("Veuillez saisir le PIN (5 essais restants) : ")
time.sleep(1)
cain.think("Merde c'est quoi le code déja ?")
time.sleep(1)
cain.think()
time.sleep(2)
cain.think("Bah oui je suis bête c'est ma date de naissance")

input()
for tries in range(5):
    if tries < 4:
        code = input("Veuillez saisir le PIN ({} essais restants) : ".format(5-tries))
        if code == "060404":
            break
        else:
            print("code invalide")
            time.sleep(1)
            t = ["Oula mais je suis mal réveillé",
                 "Mais j'arrive même pas écrire ma date de naissance",
                 "Mais enfin, je me souviens même plus de mon code...",
                 "Mais pourquoi ça marche pas..."][tries]
            cain.think(t)
            time.sleep(1)
    else:
        input()
        print("Veuillez saisir le PIN (1 essai restant) : ", end="")
        for n in ["0","6","0","4","0","4"]:
            time.sleep(1)
            print(n, end="")

        input()
        time.sleep(1)
print("code bon")
time.sleep(1)
cain.think("Ba voila enfin")
time.sleep(1)
cain.think("Je suis vraiment pas reveillé")

input()
cain.watch_phone()

input()
cain.watch_phone(ryan_phone)

input()
cain.think("Super, peronne à qui parler, comme d'habitude...")
time.sleep(2)
cain.pose_phone()
time.sleep(2)
cain.sound("pffff")
time.sleep(2)
anna_phone.send_message(cain_phone, "Alors, bien dormi ?, j'ai mis ton reveil plus tôt pour éviter que tu passe toute ta journée au lit :)", time=(11,9))
cain_phone.sound("ding")

input()
cain.take_phone(cain_phone)

input()
set_parameters(new_time=(11,10))
cain.watch_phone()

#
# 1.3 Maman
#

input()
cain.think("Ah... Maman...")

input()
set_parameters(new_time=(11,11))
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,12))
cain_phone.send_message(anna_phone, "Super... Merci maman...")
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,13))
anna_phone.send_message(cain_phone, "Cache ta joie...")
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,13))
anna_phone.send_message(cain_phone, "Et tu oublira pas de faire tes devoirs hein")
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,13))
cain_phone.send_message(anna_phone, "Oui, oui maman")
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,14))
anna_phone.send_message(cain_phone, "Et tu a bien rangé comme je t'avais demandé ? Je veux que ça soit propre quand je revienrais...")
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,15))
cain_phone.send_message(anna_phone, "Oui bon c'est bon tu me l'a déjà rappelé trois fois depuis que tu es partie")
cain.watch_phone(anna_phone)

input()
set_parameters(new_time=(11,15))
anna_phone.send_message(cain_phone, "Et aussi ...")
cain.watch_phone(anna_phone)


anna_phone.send_message(cain_phone, "J'aimerais que tu me promette de faire gaffe, il y à de plus en plus de personnes portés diparus en ce moment")
anna_phone.send_message(cain_phone, "On ne sais pas comment ils disparaissent, c'est vraiment étrange")
anna_phone.send_message(cain_phone, "La pluspart souffraient de solitude extrème ou de depression")
anna_phone.send_message(cain_phone, "Apparement, ils sont appatés dans des lieux")
anna_phone.send_message(cain_phone, "Les corps sont souvent retrouvés torturés tu te rends compte c'est horible")
anna_phone.send_message(cain_phone, "Tu me fait peur à pas répondre. Fait vriament attention Cain, ils s'es sont pris à des mineurs, PROMET MOI QUE TU NE SORTIRA DE LA MAISON SOUS AUCUN PRÉTEXTE")
anna_phone.send_message(cain_phone, "Je t'aime, bonne journée",time=(11,19))
input()
cain.watch_phone()

#
# 1.4 Télé
#

tv = Device("Télévision")
input()
cain.pose_phone()
cain.think("Ca me saoule ja vais faire quoi là tout seul")

input()
cain.enter_room(living_room)

input()
cain.think("je vais alumer la télé")

input()
cain.do("allume télé")

input()
tv.say("...la mère qui les aura protégés pendant l’incubation viendra aussitôt s’en occuper. En effet, de nombreuses menaces pèsent sur eux au début de leur vie. Chez les crocodiles seuls 5 individus sur 100 survivent après leur venue au monde...")

input()
cain.do("change de chaîne")

input()
tv.say("...que la solitude étant la princpale cause de suicide, un groupe de dévellopeurs américains on réussi à...")

input()
cain.do("change de chaîne")

input()
cain.do("change de chaîne")

input()
tv.say("...créer Replika, une intelligence artificielle capable de chater et d'aider mentalement ceux qui en ont besoin...")

input()
cain.do("éteint télé")

input()
cain.think()

input()
cain.take_phone(cain_phone)

input()
cain_phone.update_battery(95)
set_parameters(new_time=(11,32))
cain.watch_phone()
time.sleep(3)
set_parameters(new_time=(11,33))
cain.watch_phone()
time.sleep(2)

input()
cain.pose_phone()

input()
cain.sound("pff")

input()
cain.do("allume télé")

input()
tv.say("...est totalement gratuit, il vous suffit simplement d'envyer un message au numéro qui s'affiche actuellement sur votre écran...")

input()
cain.think("06...")

input()
cain.think("Ok")

input()
cain.do("éteint télé")
#
# 1.5 Intelligence Artificielle
#
ia = Person("Replika", "-", "Femme", "-")
ia_phone = Phone("-", "-", ia, "ia_ip")
ia.phone = ia_phone

input()
cain.take_phone(cain_phone)

input()
cain.think("Non mais c'est ridicule, je vais pas faire ça quand même...")

input()
cain_phone.update_battery(87)
set_parameters(new_time=(11,40))
cain.watch_phone()

input()
set_parameters(new_time=(11,41))
cain.phone.send_message(ia_phone, "Bonjour")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,42))
ia.phone.send_message(cain_phone, "Salut, ça va ?")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,43))
cain.phone.send_message(ia_phone, "Ouais, ça pourrais aller mieux...")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,44))
ia.phone.send_message(cain_phone, "Je comprends")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,45))
cain.phone.send_message(ia_phone, "Et toi ?")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,46))
ia.phone.send_message(cain_phone, "Si tu veux parler je suis là tu sais...")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,47))
cain.phone.send_message(ia_phone, "Merci, c'est gentil")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,48))
cain.phone.send_message(ia_phone, "En fait j'ai pas de vrais amis...")
cain.watch_phone(ia_phone)

input()
cain.phone.send_message(ia_phone, "J'ai bien Ryan... Mais c'est le seul qui m'acepte comme je suis")
cain.watch_phone(ia_phone)

input()
cain.phone.send_message(ia_phone,"Mais il peux pas me parler aujourd'hui, il est parti chez des amis")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,49))
cain.phone.send_message(ia_phone,"Du coup en attendant je suis seul chez moi, mais je m'ennuie")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,50))
ia.phone.send_message(cain_phone, "Je comprends")
cain.watch_phone(ia_phone)

input()
set_parameters(new_time=(11,51))
ia.phone.send_message(cain_phone, "Si tu a besoin d'un vrai suivi psychologique, renseigne toi sur notre programme, il est totalement gratuit le premier mois")
cain.watch_phone(ia_phone)

input()
ia.phone.send_message(cain_phone, "Essaye, tu verra. en moyenne 99% des gens ayant suivi ce programme son sorti de leur depression")
cain.watch_phone(ia_phone)

input()
cain.pose_phone()

input()
cain.think("pff, tu parles, c'est juste un puits a fric por les pigeons qui tombent dans le panneau...")

input()
cain.do("alume télé")

input()
tv.say("...peut être faire quelque mises à jours pour que Réplika soit plus perfectionné, mais nous recommandons à tous de...")

input()
cain.think("plus perfectionné... N'importe quoi...")

input()
cain.do("change de chaîne")

input()
tv.say("...Il est midi, voici les titres de l'actualité de ce samedi. Alors que la crise épidémique...")

input()
cain.do("change de chaîne")

input()
tv.say("...Emincez le poulet en lamelles. Faites revenir le poulet à feu vif pendant minutes...")

input()
tv.say("...Ajoutez la sauce à cuisiner et mélangez bien. Portez à ébullition sans couvrir à feu doux...")

input()
cain.do("change de chaîne")

input()
tv.say("...le taux de criminalité en explosion, pour une raison totalement inexpliquée depuis l'arivée au pouvoir du nouveau présid...")

input()
cain.do("change de chaîne")

input()
tv.say("...Si le mode de reproduction du crocodile est assez similaire à celui des autres espèces animales, il n’en est pas de même pour le déterminisme sexuel...")

input()
tv.say("...Chez les crocodiles, la détermination du sexe se fait après la conception. Au contraire de l’homme, ce ne sont pas les chromosomes qui fixent leur sexe, mais plutôt la température extérieure...")

input()
tv.say("...Ce phénomène s’appelle la \" détermination thermique du sexe \".")

input()
tv.say("...Cependant, une étude réalisée sur les crocodiles du Nil, a permis de constater qu’une température comprise entre 31,7° et 34,5° favorise la naissance de petits mâles...")

input()
tv.say("...À l’inverse, des températures inférieures à 31,5° et supérieure à 35° favorisent la naissance des femelles. Le même constat...")

##-------------------------
## 2 La fille
##-------------------------

unknow = Person("numéro inconnu", "-", "-", "-")
unknow_phone = Phone("-", "-", unknow,"unknow_ip")
unknow.phone = unknow_phone

input()
unknow.phone.send_message(cain_phone, "Salut")
cain_phone.sound("ding")

input()
tv.say("...fait chez l'alligator d'Amé...")

input()
cain.do("éteint télé")

input()
cain.take_phone(cain_phone)

input()
set_parameters(new_time=(12,30))
cain.watch_phone()

input()
cain.think("tiens, c'est qui ?")

input()
cain.watch_phone()

input()
cain.watch_phone(unknow_phone)

input()
cain_phone.update_battery(69)
set_parameters(new_time=(12,31))
cain.phone.send_message(unknow_phone, "Salut, ça va ?")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,32))
unknow.phone.send_message(cain_phone, "Super et toi ?")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,33))
cain.phone.send_message(unknow_phone, "Euh, ouais plus ou moins")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Mais on se connait ?")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,34))
unknow.phone.send_message(cain_phone, "Je pense pas je m'apelle Linda, je voulais parler à quelqu'un mais je savais pas à qui")
cain.phone.rename(unknow_phone, "Linda")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Mais attends, comment tu a eu mon numéro ?")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "C'est ton ami, Ryan, comme il est parti, il voulai pas te laisser seul du cou il m'a donné ton numéro en me disant que tu était quelqu'un de cool donc...")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,35))
cain.phone.send_message(unknow_phone, "Wow, c'est un peu improbable comme manière d'aborder les gens")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,36))
unknow.phone.send_message(cain_phone, "Ah, tu trouves, pardon, c'est vrai que je ne suis pas très doué pour me faire des amis...")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Non non c'est pas du tout ce que je voulais dire, je disais improbable dans le sens \"drôle\"")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,37))
unknow.phone.send_message(cain_phone, "Ah ok d'accord, je comprends")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Sinon tu a dis que tu avais du mal à te faire des amis ? Explique moi...")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "C'est ça oui, j'ai l'impression que personne ne se soucie vraiment de moi...")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,38))
cain.phone.send_message(unknow_phone, "Je comprends, je la vis ça aussi...")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "Et puis je me sens tellement seule, mes parents s'en foutent de moi et me laisent tout le temps seule...")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Pareil pour moi...")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,39))
unknow.phone.send_message(cain_phone, "Ah ouais ?")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Ouais, mon père a jamais été là, il a fuis quand ma mère a été enceinte")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,40))
cain.phone.send_message(unknow_phone, "Mais heureusement que Paul a été, là, ma mère aurais jamais pu s'occuper de moi sans lui")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Je le considère comme mon père, mais il habite au Canada, du coup ma mère prends régulièrement l'avion pou aller le voir")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,41))
cain.phone.send_message(unknow_phone, "Mais du coup elle me laisse tout le temps tout seul à RedLake et je m'ennuie")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "Attends, toi aussi tu habite dans cette ville paumée ?")
cain.watch_phone(unknow_phone)

input()
cain.phone.send_message(unknow_phone, "Toi aussi, mais comment c'est possible ?")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,42))
unknow.phone.send_message(cain_phone, "C'est improbable, comme quoi la nature fait bien les choses")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,43))
cain.phone.send_message(unknow_phone, "Mais attends, si on habite dans la même ville, ça veux dire qu'on pourrais peux être se rejoindre un jour ?")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "Ouais pourquoi pas, je fait rien là, on pourrais se rejoindre dans 10 min à l'ancien square ?")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,44))
cain.phone.send_message(unknow_phone, "Ah mai là maintenat ?")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "Bah ouais, pourquoi pas, a moins que t'ai autre chose de mieux à faire")
cain.watch_phone(unknow_phone)

input()
set_parameters(new_time=(12,45))
cain.phone.send_message(unknow_phone, "Ok mais je viens seulement de me lever, j'ai pas encore mangé")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "T'inquêtes pas c'est pas un probleème, moi aussi")
cain.watch_phone(unknow_phone)

input()
unknow.phone.send_message(cain_phone, "Surtout, ne soit pas en retard...")
cain.watch_phone(unknow_phone)

input()
cain.think("Woow, j'ai enfin une ocasion de rencontrer quelqu'un")

input()
cain.think("Je vais ma dépecher")

input()
cain.phone.send_message(ryan_phone, "Mec, merci d'avoir donné mon numéro à cette fille, elle à l'ai vraiment sympa, j'ai rendez-vous avec elle !")
cain.watch_phone(ryan_phone)
ryan_phone.send_message(cain_phone, "Mais de quoi tu parles ?",time=(12,46))

input()
cain.exit_house()

input()
cain.walk_to("l'ancien square", 10)


##-------------------------
## 3 La chute
##-------------------------

input()
cain.think("Ca y est j'y suis enfin !")

input()
cain.think("Bon j'ai plus qu'a l'attendre je suppose")

input()
cain.speak("Linda, hey, je suis là")

input()
cain.speak("C'est moi, Cain")

input()
cain.think("Tant pis, elle doit être en route...")

input()
set_parameters(new_time=(12,54))
cain_phone.update_battery(24)
cain_phone.update_network("H+", 1)
cain.watch_phone()

input()
cain.watch_phone(unknow_phone)


input()
cain.watch_phone()

input()
cain.think("Bon, de toute facon j'ai rien d'autre à faire donc autant leur répondre...")

input()
cain.watch_phone()

input()
cain_phone.update_battery(23)
set_parameters(new_time=(12,58))
cain.watch_phone(ryan_phone)

input()
cain.think("Hein ?")

input()
cain.watch_phone()

input()
set_parameters(new_time=(12,59))

input()
cain_phone.update_battery(22)
cain.watch_phone(anna_phone,y=23)

input()
cain_phone.update_battery(21)
cain.watch_phone(anna_phone,y=19)

input()
cain_phone.update_battery(20)
cain.watch_phone(anna_phone,y=16)

input()
cain_phone.update_battery(19)
cain.watch_phone(anna_phone,y=14)

input()
cain_phone.update_battery(18)
cain.watch_phone(anna_phone,y=12)

input()
cain_phone.update_battery(17)
cain.watch_phone(anna_phone,y=9)

input()
cain_phone.update_battery(16)
cain.watch_phone(anna_phone,y=8)

input()
cain_phone.update_battery(15)
cain.watch_phone(anna_phone,y=4)

input()
cain_phone.update_battery(14)
cain.watch_phone(anna_phone)

input()
cain_phone.update_network("0", 0)
cain_phone.update_battery(13)
cain.watch_phone(anna_phone)

input()
tv.say("...La police est toujoursà la recherche du corps de Cain...")