# -*- coding: utf-8 -*-
"""
Created on Thu Nov  4 09:35:55 2021

@author: mrayn
"""
# 🥶 BING CHILLING 🍦
# https://www.youtube.com/embed/AWOyEIuVzzQ


from random import randint
from unicodedata import normalize, category
#from unidecode import unidecode #pip install Unidecode

class bcolors:
    """Classes de couleurs pour le terminal"""
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKCYAN = '\033[96m'
    OKGREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'



class Garde:
    """Classe Garde"""

    def __init__(self, Nom: str, Vie: int):
        self.nom = Nom
        self.__vie = Vie
        self.__vie_max = Vie
        self.__arme = Arme("Épée de Garde", legendaire, 20,1)

    def est_vaincu(self) -> bool:
        """
        Retourne True si le garde est vaincu
        """
        return self.__vie <= 0

    def prendre_degats(self, degats: int):
        """
        Inflige des dégats au garde, vérifie si il est vaincu et retourne sa vie restante
        """
        self.__vie -= degats
        if self.est_vaincu():
            return "{} est vaincu!".format(self.nom)
        return self.__vie

    def voir_arme(self):
        """Retourne l'arme du garde"""
        return self.__arme

    def vie(self):
        """Retourne la vie du garde"""
        return self.__vie
    def vie_max(self):
        """Retourne la vie max du garde"""
        return self.__vie_max

    def __repr__(self):
        return "Garde()"

    def __str__(self):
        return "Garde nommé: {}, {}".format(
            self.nom, "vaincu" if self.est_vaincu() else "pas encore vaincu"
        )


class Vallee:
    """Vallée listant les gardes restants"""
    def __init__(self, Controle):
        self.controle = Controle

    def cibles_dispo(self) -> list:
        """
        Retourne la liste des cibles disponibles
        """
        return self.controle + ["paysans"]

    def __repr__(self):
        return "Vallee()"

    def __str__(self):
        return "Vallée controlée par: {}".format(self.controle)

class Joueur:
    """Classe du joueur"""
    def __init__(self, Vie: int, Defense: int, Inventaire: list, Experience: int):
        self.__vie = Vie
        self.__defense = Defense
        self.__defense_max = Defense
        self.__inventaire = Inventaire
        self.__experience = Experience
        self.__masse_transporte = 0
        self.__masse_transporte_max = 10
        self.calculer_masse_transportee()
        self.__forge_decouverte = False
        self.__arme=Inventaire[0]

    def forge_decouverte(self):
        """Retourne True si la forge est découverte"""
        return self.__forge_decouverte

    def prendre_degats(self, degats: int):
        """
        Inflige des dégats au joueur, vérifie si il est vaincu et retourne sa vie restante
        """
        self.__vie -= degats
        if self.est_vaincu():
            return "Vous avez été est vaincu!"
        return self.__vie

    def voir_arme(self):
        """Retourne l'arme du joueur"""
        return self.__arme

    def selectionner_arme(self):
        """Sélectionne l'arme du joueur"""
        armes=[]
        for item in self.__inventaire:
            if isinstance(item, Arme):
                armes.append(item)
        if len(armes) == 0:
            print("Vous n'avez pas d'armes pour vous battre")
            return
        texte_armes=""
        for arme in armes:
            texte_armes+=f"[{bcolors.OKBLUE}{armes.index(arme)+1}{bcolors.ENDC}] {arme.__str__()} .\n"
        rep=sanitizer(input("Les armes disponibles sont:\n"+texte_armes))
        if rep.isdigit():
            if 0 < int(rep) <= len(armes):
                arme=armes[int(rep)-1]
                self.__arme=arme
                print("Vous avez choisi l'arme: "+arme.__str__())

    def attaquer(self, cible) ->str:
        """Attaque une cible"""
        if cible.startswith("paysans") or cible.startswith("paysan") :
            exp=randint(1,10)
            self.__experience += exp
            return "Le paysan a été tué, cela ne vous rapporte que {} points d'experience".format(exp)
        if cible =="pillard":
            self.__experience += 10
            self.prendre_degats(20)
            return "Le pillard a été tué, vous avez pris 20 points de dégats cela vous rapporte que 10 points d'experience"
        if cible.startswith("garde") or cible.startswith("gardes"):
            if cible == sanitizer("Garde du fort du Pech"):
                self.selectionner_arme()
                combatFortPech=Combat(self,gardeFortPech)
                while not combatFortPech.est_fini():
                    combatFortPech.jouer_tour()
                if self.est_vaincu():
                    return "Vous avez été vaincu."
                self.__experience += 40
                return "Vous avez tué le garde du fort du Pech et obtenez 40 points d'expérience!"
            if cible == sanitizer("Garde du Trech"):
                self.selectionner_arme()
                combatTrech=Combat(self,gardeTrech)
                while not combatTrech.est_fini():
                    combatTrech.jouer_tour()
                if self.est_vaincu():
                    return "Vous avez été vaincu."
                self.__experience += 40
                return "Vous avez tué le garde du Trech et obtenez 40 points d'expérience!"
            if cible == sanitizer("Garde de l'écart de la Combe"):
                self.selectionner_arme()
                combatEcartCombe=Combat(self,gardeEcartCombe)
                while not combatEcartCombe.est_fini():
                    combatEcartCombe.jouer_tour()
                if self.est_vaincu():
                    return "Vous avez été vaincu."
                self.__experience += 40
                return "Vous avez tué le garde de l'écart de la Combe et obtenez 40 points d'expérience!"
        cibles=[]
        for objectif in vallee.cibles_dispo():
            if isinstance(objectif, Garde):
                cibles.append(objectif.nom)
            else:
                cibles.append(objectif)
        return "Cible non prise en charge, les cibles disponibles sont:"+ str(cibles)

    def est_vaincu(self) -> bool:
        """ Retourne True si le joueur est vaincu """
        return self.__vie <= 0

    def inventaire(self):
        """Retourne l'inventaire du joueur"""
        return self.__inventaire

    def voir_inventaire(self):
        """Retourne l'inventaire du joueur d'une manière plus lisible"""
        ret = "Votre inventaire contient:\n"
        for objet in self.__inventaire:
            ret+= " - {}\n".format(objet)
        return ret+f"\nMasse contenue: {self.__masse_transporte}/{self.__masse_transporte_max}.\n{self.__vie} / 100 vie, {self.__defense} défense, {self.__experience} points d'expérience"

    def calculer_masse_transportee(self):
        """Calcule la masse transportée"""
        masse_transporte = 0
        for objet in self.__inventaire:
            if isinstance(objet, Arme):
                masse_transporte += objet.masse_total()
            else:
                masse_transporte += objet.masse
        self.__masse_transporte = masse_transporte
        if self.__masse_transporte > self.__masse_transporte_max:
            self.__defense = 0
            print("Vous transportez trop de choses, vous n'avez donc plus de défense tant que vous ne lachez rien.")
        else:
            self.__defense = self.__defense_max
        return self.__masse_transporte

    def recuperer_objet(self, objet):
        """Ajoute un objet à l'inventaire"""
        self.__inventaire.append(objet)
        self.calculer_masse_transportee()

    def jeter(self, objet:str):
        """Jette un objet de l'inventaire"""
        for obj in self.__inventaire:
            if obj.nom == objet:
                if sanitizer(input(f"Voulez-vous vraiment jeter {obj.nom} ? ({bcolors.OKBLUE}O{bcolors.ENDC}/{bcolors.OKBLUE}N{bcolors.ENDC})")) == "O":
                    self.__inventaire.remove(obj)
                    self.calculer_masse_transportee()
                    return "Vous avez jeté {}.".format(obj.nom)
                return "Vous n'avez rien jeté."
        return "Vous ne possédez pas cet objet."

    def explorer(self, zone_a_explorer)->str:
        """
        Explore une zone
        """
        if zone_a_explorer in ("paysans", "paysan","champ", "champs") :
            if not zonesExplorees["champs"]:
                if randint(0,2) == 0:# 1 chance sur 3
                    zonesExplorees["champs"]=True
                    rep=sanitizer(input(f"Vous avez trouvé de grands morceaux de cuir près de chez les paysans, vous pourriez les utiliser pour:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] renforcer le manche de vos armes (5% taille; 1 dégats)\n[{bcolors.OKBLUE}2{bcolors.ENDC}] confectionner des protections pour vos jambes (8 défense)\n[{bcolors.OKBLUE}3{bcolors.ENDC}] les garder pour plus tard. (1 masse)\n\n"))
                    if rep == "1":
                        for objet in self.__inventaire:
                            if isinstance(objet, Arme):
                                objet.ameliorer(Modificateur('Cuir',Degats=1,Taille=0.05))
                        return "Vous avez utilisé les morceaux de cuir pour renforcer vos armes. (5% taille; 1 dégats)"
                    if rep == "2":
                        self.__defense_max+=8
                        self.calculer_masse_transportee()
                        return "Vous avez confectionné des protections pour vos jambes. (8 défense)"
                    self.recuperer_objet(Objet("Cuir", 1))
                    return "Vous avez gardé les morceaux de cuir pour plus tard."
                exp=randint(1,3)
                self.__experience+=exp
                return "Vous avez exploré la zone des paysans et vous avez gagné {} points d'expérience.".format(exp)
            return "Vous avez deja exploré la zone {}".format(zone_a_explorer)
        if zone_a_explorer == "fort du pech":
            if not zonesExplorees["fort"]:
                if gardeFortPech.est_vaincu():
                    zonesExplorees["fort"]=True
                    self.__forge_decouverte = True
                    self.__experience+=50
                    return "Vous découvrez la forge, ici, vous pouvez reforgez vos armes contre des points d'expérience pour tenter d'obtenir un modificateur différent.\nReforgez une arme à l'aide de la commande reforger <nom de l'arme>.\nVous gagnez 50 points d'expérience."
                return "Il serait trop dangereux de s'aventurer dans le Fort du Pech alors que le garde est encore présent"
            return "Vous avez deja exploré la zone {}".format(zone_a_explorer)

        if zone_a_explorer in("trech","le trech"):
            if not zonesExplorees["trech"]:
                if gardeTrech.est_vaincu():
                    zonesExplorees["trech"]=True
                    self.recuperer_objet(epeeCobalt)
                    return "Vous récupérez l'épée du garde, c'est une épée en Cobalt: \n{}\n".format(epeeCobalt.__str__())
                return "Il serait trop dangereux de s'aventurer dans le Trech alors que le garde est encore présent"
            return "Vous avez deja exploré la zone {}".format(zone_a_explorer)
        if zone_a_explorer == sanitizer("La Côte"):
            if not zonesExplorees["cote"]:
                if randint(0,4) == 0: # 1 chance sur 5
                    zonesExplorees["cote"]=True
                    self.recuperer_objet(Objet("Bandages", 1))
                    rep=sanitizer(input(f"Vous avez trouvé des bandages, vous pourriez les utiliser pour:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] soigner vos blessures avec un bandage (20 vie)\n[{bcolors.OKBLUE}2{bcolors.ENDC}] soigner vos blessures avec les deux bandages (40 vie)\n[{bcolors.OKBLUE}3{bcolors.ENDC}] les garder pour plus tard. (2 masse)\n\n"))
                    if rep == "1":
                        if self.__vie>80:
                            self.__vie=100
                        else:
                            self.__vie+=20
                        return "Vous avez utilisé un bandages pour soigner vos blessures. (20 vie)\n\nMaintenant {} vie, {} défense.\n".format(self.__vie, self.__defense)
                    if rep == "2":
                        if self.__vie>60:
                            self.__vie=100
                        else:
                            self.__vie+=40
                        return "Vous avez utilisé les bandages pour soigner vos blessures. (40 vie)\n\nMaintenant {} vie, {} défense.\n".format(self.__vie, self.__defense)
                    self.recuperer_objet(Objet("Bandages", 2))
                    return "Vous avez gardé les bandages pour plus tard. (2 masse)"
            return "Vous avez deja exploré la zone {}".format(zone_a_explorer)
        if zone_a_explorer == sanitizer("l'écart de la Combe") or zone_a_explorer== sanitizer("écart de la Combe"):
            if not zonesExplorees["combe"]:
                if gardeEcartCombe.est_vaincu():
                    zonesExplorees["combe"]=True
                    self.__defense_max+=15
                    self.__masse_transporte_max+=10
                    self.recuperer_objet(Objet("Feraille", 6))
                    return"Vous trouvez une armure et un sac à dos! (15 défense; 10 masse maximum)\nMaintenant {} vie, {} défense.\n\nVous récupérez aussi un seau de feraille (6 masse)".format(self.__vie, self.__defense)
                return "Il serait trop dangereux de s'aventurer dans l'écart de la Combe alors que le garde est encore présent"
            return "Vous avez deja exploré la zone {}".format(zone_a_explorer)
        if zone_a_explorer == sanitizer("forêt"):
            amt_bois=randint(1,8)
            rep=sanitizer(input(f"Dans cette forêt vous pouvez:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] récupérer du bois ({amt_bois} masse)\n[{bcolors.OKBLUE}2{bcolors.ENDC}] ne rien faire"))
            if rep == "1":
                self.recuperer_objet(Objet("Bois", {amt_bois}))
                return f"Vous avez récupéré du bois ({amt_bois} masse)"
            return "Vous n'avez rien fait"
        if zone_a_explorer == sanitizer("cimetière"):
            if not zonesExplorees["cimetiere"]:
                zonesExplorees["cimetiere"]=True
                arme:Arme=generer_objet_aleatoire(chanceArme)
                exp=randint(10,30)
                self.__experience+=exp
                rep=sanitizer(input(f"Vous obtenez {exp} points d'expérience et avez trouvé une arme: \n{arme.__str__()}\nVous pouvez:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] garder l'arme\n[{bcolors.OKBLUE}2{bcolors.ENDC}] ne pas la prendre\n"))
                if rep == "1":
                    self.recuperer_objet(arme)
                    return f"Vous avez récupéré {arme.nom} ({arme.masse_total()} masse)"
                return "Vous n'avez rien fait"
            return "Vous avez deja exploré la zone {}".format(zone_a_explorer)
        if zone_a_explorer in ("ruines","ruine"):
            if randint(0,2) == 0:# 1 chance sur 3
                rep=sanitizer(input(f"Vous avez trouvé une hache: \n{hache.__str__()}\nVous pouvez:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] garder l'arme\n[{bcolors.OKBLUE}2{bcolors.ENDC}] ne pas la prendre\n"))
                if rep == "1":
                    self.recuperer_objet(hache)
                    return "Vous avez récupéré la hache ({} masse)".format(hache.masse_total())
                return "Vous n'avez rien fait"
            if randint(0,2) == 0:# 1 chance sur 3
                rep=sanitizer(input(f"Vous avez trouvé des pillards, \nVous pouvez:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] attaquer le pillard\n[{bcolors.OKBLUE}2{bcolors.ENDC}] vous soigner puis attaquer\n[{bcolors.OKBLUE}3{bcolors.ENDC}] fuir\n"))
                if rep == "1":
                    return self.attaquer("pillard")
                if rep == "2":
                    self.__vie+=20
                    return self.attaquer("pillard")
                return "Vous avez fui"
            if randint(0,2) == 0:# 1 chance sur 3
                #le joueur trouve une potion de dégats utilisable en combats
                rep=sanitizer(input(f"Vous avez trouvé une potion de dégats, vous pourrrez l'utiliser en combat:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] la prendre\n[{bcolors.OKBLUE}2{bcolors.ENDC}] ne pas la prendre\n"))
                if rep == "1":
                    self.recuperer_objet(Objet("Potion de dégats", 1))
                    return "Vous avez récupéré une potion de dégats (1 masse)"
                return "Vous n'avez rien fait"
            exp=randint(5,20)
            self.__experience+=exp
            return f"Vous avez gagné {exp} points d'expérience"
        if zone_a_explorer == "village":
            #le joueur rencontre un marchand qui lui propose d'échanger ses armes contre d'autres armes en échange de pointsd'expérience
            rep=sanitizer(input(f"Vous rencontrez un marchand qui vous propose d'échanger vos armes contre d'autres armes en échange de points d'expérience:\n[{bcolors.OKBLUE}1{bcolors.ENDC}] accepter\n[{bcolors.OKBLUE}2{bcolors.ENDC}] refuser\n"))
            if rep == "1":
                armes=[]
                for item in self.__inventaire:
                    if isinstance(item, Arme):
                        armes.append(item)
                if len(armes) == 0:
                    return "Vous n'avez pas d'armes à échanger"
                texte_armes=""
                exp=randint(20,50)
                for arme in armes:
                    texte_armes+=f"[{bcolors.OKBLUE}{armes.index(arme)+1}{bcolors.ENDC}] {arme.__str__()} pour {exp} points d'expérience.\n"
                rep = sanitizer(input(f"Vous avez {len(armes)} armes à échanger, laquelle souhaitez vous marchander:\n"+texte_armes))
                if rep.isdigit():
                    if 0 < int(rep) <= len(armes):
                        arme=armes[int(rep)-1]
                        if self.__experience >= exp:
                            self.__experience-=exp
                            self.__inventaire.remove(arme)
                            nouvelle_arme:Arme=generer_objet_aleatoire(chanceArme)
                            self.recuperer_objet(nouvelle_arme)
                            return f"Vous avez échangé votre {arme.nom} pour {exp} points d'expérience contre {nouvelle_arme.__str__()}"
                        return "Vous n'avez pas assez d'expérience pour échanger"

                return "Vous n'avez pas échangé d'armes"
        return "Cette zone n'est pas accessible"

    def reforger(self, nom_arme):
        """Reforge une arme"""
        for objet in self.__inventaire:
            if isinstance(objet, Arme):
                if objet.nom == nom_arme:
                    #reforger objet
                    ran=randint(1,100)/100
                    for mod in chanceModificateur:
                        if ran <= mod[1]:
                            objet.reforger(mod[0])
                            return "Vous avez reforgez l'arme {} avec le modificateur {} :\n{}".format(objet.nom,mod[0].nom,mod[0].__str__())
        return "Vous n'avez pas cette arme dans votre inventaire."

    def utiliser(self, objet):
        """Utilise un objet"""
        for item in self.__inventaire:
            if sanitizer(item.nom) == objet:
                if objet == "Potion de dégats":
                    return "Vous ne pouvez utiliser une potion de dégats qu'en combat"
                if objet == "Bandages":
                    if self.__vie>80:
                        self.__vie=100
                    else:
                        self.__vie+=20
                    item.masse-=1
                    return "Vous avez utilisé un bandages pour soigner vos blessures. (20 vie)\n\nMaintenant {} vie, {} défense.\n".format(self.__vie, self.__defense)
        return "Vous n'avez pas cet objet dans votre inventaire."
    def retirer(self, objet):
        """Retire un objet de l'inventaire"""
        for item in self.__inventaire:
            if sanitizer(item.nom) == objet:
                self.__inventaire.remove(item)
    def soigner(self,soin):
        """Soigne le joueur"""
        self.__vie+=soin
        if self.__vie+soin > 100:
            self.__vie=100
    def defense(self):
        """Retourne la défense du joueur"""
        return self.__defense

    def vie(self):
        """Retourne la vie du joueur"""
        return self.__vie

    def __repr__(self):
        return "Joueur()"

    def __str__(self):
        return "Le joueur possède {} points de vie sur 100, {} points de défense, {} points d'expérience et {} dans son inventaire.".format(self.__vie, self.__defense, self.__experience, self.__inventaire)


class Modificateur:
    """Classe modificateur"""
    def __init__(self, Nom: str, Degats=0, Critique=0, Vitesse=0, Recul=0, Taille=0):
        self.nom = Nom
        self.__degats = Degats  # Dégats ajoutés
        self.__critique = Critique  # Pourcentage de chance de coup critique ajouté
        self.__vitesse = Vitesse  # Pourcentage de vitesse ajoutée
        self.__recul = Recul  # Pourcentage de recul ajouté, le recul réduit la vitesse de l'ennemi à chaque coup
        self.__taille = Taille  # Pourcentage de taille ajoutée, la taille augmente le masse de l'objet transporté
    def stat(self, statistique:str):
        """Retourne une statistiques du modificateur"""
        return {
            "degats": self.__degats,
            "critique": self.__critique,
            "vitesse": self.__vitesse,
            "recul": self.__recul,
            "taille": self.__taille,
        }[statistique]

    def __add__(self, other):
        """Additionne deux modificateurs"""
        assert isinstance(other, Modificateur), "L'objet n'est pas un modificateur"
        return Modificateur(
            self.nom,
            self.__degats + other.stat("degats"),
            self.__critique + other.stat("critique"),
            self.__vitesse + other.stat("vitesse"),
            self.__recul + other.stat("recul"),
            self.__taille + other.stat("taille"),
        )
    def __repr__(self):
        return "Modificateur()"

    def __str__(self):
        return "Modificateur nommé: {}, ajoute {} points de dégats, {}% de chance de coup critique, {}% de vitesse, {}% de recul et {}% de taille.".format(
            self.nom, self.__degats, self.__critique, self.__vitesse, self.__recul, self.__taille
        )


class Arme:
    """Classe arme"""
    def __init__(self, Nom: str, Prefixe: Modificateur, Degats: int,Masse: int,Crit=0.02,Vit=1,Rec=1):
        self.nom = Prefixe.nom + " " + Nom
        self.__modificateur = Prefixe
        self.__degats = Degats
        self.__masse = Masse
        self.__critique = Crit
        self.__vitesse = Vit
        self.__recul = Rec

    def degats_total(self) -> int:
        """Retourne les dégats de l'arme"""
        return self.__degats + self.__modificateur.stat("degats")

    def masse_total(self) -> int:
        """Retourne la masse de l'arme"""
        return self.__masse * (1 + self.__modificateur.stat("taille"))

    def chance_critique_total(self) -> int:
        """Retourne la chance de coup critique de l'arme"""
        return self.__critique + self.__modificateur.stat("critique")

    def vitesse_total(self) -> int:
        """Retourne la vitesse de l'arme"""
        return self.__vitesse * (1+ self.__modificateur.stat("vitesse"))

    def recul_total(self) -> int:
        """Retourne le recul de l'arme"""
        return self.__recul * (1+ self.__modificateur.stat("recul"))

    def ameliorer(self, modificateur: Modificateur):
        """Ajoute un modificateur à l'arme"""
        self.__modificateur += modificateur

    def reforger(self, modificateur: Modificateur):
        """Change le modificateur de l'arme"""
        self.__modificateur = modificateur

    def __repr__(self):
        return "Arme()"


    def __str__(self):
        return "{}, masse de {}, {} points de dégats, {}% de chance de coup critique, vitesse de {} et {} points de recul".format(self.nom, self.masse_total(), self.degats_total(), self.chance_critique_total()*100, self.vitesse_total(), self.recul_total())

class Combat:
    """Classe combat"""
    def __init__(self, JOUEUR: Joueur, ennemi):
        self.__potions_degats=False


        self.joueur = JOUEUR
        self.joueur_avancement=0
        self.joueur_degats=self.joueur.voir_arme().degats_total()
        self.joueur_vitesse=self.joueur.voir_arme().vitesse_total()

        self.ennemi = ennemi
        self.ennemi_avancement=0
        self.ennemi_degats=self.ennemi.voir_arme().degats_total()
        self.ennemi_vitesse=self.ennemi.voir_arme().vitesse_total()


    def est_fini(self) -> bool:
        """Retourne si le combat est fini"""
        return self.joueur.est_vaincu() or self.ennemi.est_vaincu()

    def jouer_tour(self):
        """Joue un tour de combat"""
        self.joueur_avancement += self.joueur_vitesse
        self.ennemi_avancement += self.ennemi_vitesse

        if self.joueur_avancement >= 100:
            self.affichage()
            self.joueur_avancement = 0
            possibilites=f"[{bcolors.OKBLUE}1{bcolors.ENDC}] Attaquer\n"
            if sanitizer("bandage") in joueur.inventaire():
                possibilites+=f"         [{bcolors.OKGREEN}2{bcolors.ENDC}] Bandage (20 vie)\n"
            if sanitizer("potion de dégats") in joueur.inventaire():
                possibilites+=f"         [{bcolors.OKGREEN}3{bcolors.ENDC}] Potion de dégats (degats x2)\n"
            rep = sanitizer(input(possibilites))
            if rep == "1":
                crit=1
                if randint(0,100)/100<self.joueur.voir_arme().chance_critique_total():
                    crit=2
                if self.__potions_degats:
                    deg=2
                else:
                    deg=1
                degats_final=self.joueur.voir_arme().degats_total()*crit*deg
                self.__potions_degats=False
                self.ennemi.prendre_degats(degats_final)
                self.ennemi_avancement-=self.joueur.voir_arme().recul_total()*10
                print(f"{bcolors.OKCYAN}Vous avez infligé {degats_final} dégats{bcolors.ENDC}")
            if rep == "2":
                if sanitizer("bandage") in joueur.inventaire():
                    joueur.inventaire().retirer(sanitizer("bandage"))
                    joueur.soigner(20)
                    print(f"{bcolors.OKGREEN}Vous avez utilisé un bandage{bcolors.ENDC}")
                print("Vous n'avez pas ça sur vous. Trop tard !")
            if rep == "3":
                if sanitizer("potion de dégats") in joueur.inventaire():
                    joueur.inventaire().retirer(sanitizer("potion de dégats"))
                    self.__potions_degats=True
                    print(f"{bcolors.OKGREEN}Vous avez utilisé une potion de dégats{bcolors.ENDC}")
                print("Vous n'avez pas ça sur vous. Trop tard !")
        elif self.ennemi_avancement >= 100:
            self.affichage()
            self.ennemi_avancement = 0
            crit=1
            if randint(0,100)/100<self.ennemi.voir_arme().chance_critique_total():
                crit=2
            degats_final=self.ennemi.voir_arme().degats_total()*crit
            self.joueur.prendre_degats(degats_final-self.joueur.defense())
            self.joueur_avancement-=self.ennemi.voir_arme().recul_total()*10
            print(f"{bcolors.FAIL}L'ennemi vous a infligé {degats_final} dégats{bcolors.ENDC}")

    def affichage(self):
        """Affiche les informations du combat"""
        print("Joueur:")
        print(f"vie: {self.joueur.vie()} / 100; défense: {self.joueur.defense()}; avancement: {self.joueur_avancement}\n")
        print("Ennemi:")
        print(f"vie: {self.ennemi.vie()} / {self.ennemi.vie_max()}; défense: 0; avancement: {self.ennemi_avancement}\n\n")

    def __repr__(self):
        return "Combat()"

    def __str__(self):
        return "Combat entre {} et {}".format(self.joueur, self.ennemi)

class Objet:
    """Classe pour objet quelconque"""
    def __init__(self, Nom: str, Masse: int):
        self.nom = Nom
        self.masse = Masse

    def __repr__(self):
        return "Objet()"

    def __str__(self):
        return f"{bcolors.BOLD}{self.nom}{bcolors.ENDC}, de masse de {self.masse}."


def generer_objet_aleatoire(liste_objets:list):
    """Génère un objet aléatoire selon une liste sous la forme: [(objet,poids)]"""
    ran=randint(1,100)/100
    for obj in liste_objets:
        if ran <= obj[1]:
            return obj[0]

def sanitizer(string: str) -> str:
    """Fonction de sanitisation de chaîne de caractères"""
    #return unidecode(normalize('NFC',string.lower()))

    # normalize('NFD',str) permet de dissocier les lettres des accents, category vérifie si le caractère est un accent et lower permet de ne pas avoir de problème avec les majuscules
    return ''.join(c for c in normalize('NFD', string.lower()) if category(c) != 'Mn')


def repondre(reponse) -> str:
    """Fonction qui permet de répondre à une commande"""
    parametres=" ".join(reponse.split(" ")[1:])
    if reponse.startswith("attaquer"):
        return joueur.attaquer(parametres)
    if reponse == "inventaire":
        return joueur.voir_inventaire()
    if reponse.startswith("explorer "):
        return joueur.explorer(parametres)
    if reponse.startswith("utiliser "):
        return joueur.utiliser(parametres)
    if reponse.startswith("lacher") or reponse.startswith("jeter"):
        return joueur.jeter(parametres)
    if reponse.startswith("details"):
        for obj in joueur.inventaire():
            if sanitizer(obj.nom) == parametres:
                return "Vous regardez les détails de {}:\n{}".format(parametres,obj.__str__())
        return "Vous ne possédez pas cet objet"
    if reponse.startswith("reforger") and joueur.forge_decouverte():
        joueur.reforger(parametres)
        return "Vous reforgez {}".format(parametres)
    if reponse == "aide":
        return aide_commandes()
    if reponse == "quitter":
        return "Vous quittez le jeu"
    return "Erreur dans la requête"


def aide_commandes() -> str:
    """Fonction qui retourne l'aide des commandes"""
    listeCommandes = [("attaquer","nom de l'ennemi"),("inventaire",""),("explorer","nom de la zone"),("utiliser","nom de l'objet"),("lacher","nom de l'objet"),("details","nom de l'objet"),("aide",""),("quitter","")]
    if joueur.forge_decouverte():
        listeCommandes.append(("reforger","nom de l'objet"))

    ret=f"{bcolors.HEADER}Voici la liste des commandes disponibles:\n"
    for commande in listeCommandes:
        if commande[1]=="":
            ret+=f"{bcolors.OKBLUE}" + commande[0]+"\n"
        else:
            ret+=f"{bcolors.OKBLUE}" + commande[0] + f" {bcolors.ENDC}<" + commande[1]+">\n"
    return ret + bcolors.ENDC



if __name__ == '__main__':

    #  Modificateurs:
    robuste = Modificateur("Robuste", 2, Taille=-0.05)
    puissant = Modificateur("Puissant", Recul=0.15)
    deplaisant = Modificateur("Deplaisant", 1, Recul=0.15)
    agile = Modificateur("Agile", Vitesse=0.15)
    zele = Modificateur("Zélé", Critique=0.10)
    demoniaque = Modificateur("Démoniaque", 3, Critique=0.05)
    derangeant = Modificateur("Dérangeant", -4, Vitesse=-0.15)
    faible = Modificateur("Faible", -1, Recul=-0.20)
    terrible = Modificateur("Terrible", -3, Taille=0.13,Recul=0.15)
    leger = Modificateur("Léger", Recul=-0.10, Vitesse=+0.15)
    legendaire = Modificateur("Légendaire", 3, Vitesse=0.10,Recul=0.15,Critique=0.05,Taille=-0.10)
    celeste = Modificateur("Céleste",2, Vitesse=-0.10, Recul=0.10)

    chanceModificateur = [(robuste,0.20),(puissant,0.35),(deplaisant,0.45),(agile,0.57),(zele,0.60),(demoniaque,0.65),(derangeant,0.75),(faible,0.85),(terrible,0.90),(leger,0.94),(legendaire,0.96),(celeste,1.00)]


    # Gardes:
    gardeFortPech = Garde("Garde du fort du Pech", 300)
    gardeTrech = Garde("Garde du Trech", 150)
    gardeEcartCombe = Garde("Garde de l'écart de la Combe", 400)

    # Armes:
    epeeFer = Arme("Epée en fer", robuste, 8,3)
    epeeFeraille = Arme("Epée en feraille", generer_objet_aleatoire(chanceModificateur), 9,2)
    epeeCourteBois = Arme("Epée courte en bois", generer_objet_aleatoire(chanceModificateur), 6,2,Vit=1.7)
    fleauOmbres = Arme("Fleau des ombres",generer_objet_aleatoire(chanceModificateur), 17, 12,Vit=0.9)
    lance = Arme("Lance",generer_objet_aleatoire(chanceModificateur), 9, 6,Vit=1,Rec=2)
    hache = Arme("Hache",generer_objet_aleatoire(chanceModificateur), 12, 8,Vit=0.5,Rec=1.2)
    epeeCobalt = Arme("Epée en cobalt",generer_objet_aleatoire(chanceModificateur), 34, 15,Vit=0.5,Rec=1.2,Crit=0.10)

    chanceArme = [(epeeFeraille,0.05),(epeeFer,0.30),(epeeCourteBois,0.60),(fleauOmbres,0.70),(lance,0.90),(hache,0.99),(epeeCobalt,1.00)]


    zonesExplorees={"champs":False,"trech":False,"combe":False,"fort":False,"cimetiere":False,"cote":False,"foret":False,"ruines":False,"village":False}
    vallee = Vallee([gardeEcartCombe, gardeFortPech, gardeTrech])
    joueur = Joueur(100, 0, [epeeFer], 0)

    print(
        "Vous êtes un chevalier et votre objectif est de reprendre le contrôle de la vallée. \nPour cela, vous pourrez attaquer des pauvres paysans pour obtenir des ressources facilement, fouiller des ruines et enfin essayer attaquer les 3 gardes de la vallée: le {}, le {} et le {}.".format(
            gardeFortPech.nom, gardeEcartCombe.nom, gardeTrech.nom
        )
    )

    print(repondre("aide"))

    retour=""
    while retour != "quitter" and not joueur.est_vaincu():
        retour = sanitizer(input())
        print(repondre(retour))
